# ============================================================
# ============================================================
#
#   This script prompts the user for a filename.
#   It performs the substitutions: 
#      s/e/ 10^ /g;
#      s/E/ 10^ /g;
#   which globally replaces "e" and "E" with " 10^ "
#   and then writes the changed file 
#   to an output file (currently t.t)
#   
#   If you ever have to do some non-interactive changes,
#   or want to do file I/O in Perl, this will save you 
#   a few hours. It also has some debugging features. 
#   
# ============================================================

#!/usr/bin/perl

$fileIn = @ARGV[0];
open(IN,$fileIn) || die " error in input file";

# ====== This hardwires the output file a given in the command line
$fileOut = @ARGV[1];
open(OUT,">$fileOut") || die " error in output file";

# ====== Initialization
$n=1;
$line=0;
$debug=0;  # Debug flag: 0= no printout; ne 0: printout
print " \n";

# ====== Start the main loop: 
while(<IN>) {

   $n=$n+1;
   $line=$line+1;
   $diff=0;

   my $before=$_;
   s/(\d)(-|\+)(\d)/$1E$2$3/g;
   my $after=$_;
   if($before ne $after){$diff=1};

   print  OUT $_; #  THIS PRINTS TO OUTPUT FILE: 

# ====== PRINT STUFF GOES HERE: 
   if(($debug ne 0) or ($diff ne 0 )){
           print " \n";
	   print "\# $line ====================================== \n";
	   if($diff ne 0){ print " ********** DIFFERENT \n";};
           print "     ",$before;
           print "     "," -------------------------------------- \n";
           print "     ",$after;
	   $diff=0;
   }  #==== END OF DEBUG LOOP

} # ====== End the main loop: 

    print "\#$line ====================================== \n";

# ====== Cleanup
close(IN);
close(OUT);

print "All Done!\n";
