(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    113214,       2757]
NotebookOptionsPosition[    104278,       2480]
NotebookOutlinePosition[    104659,       2497]
CellTagsIndexPosition[    104616,       2494]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.5394746065275707`*^9, 3.539474619342907*^9}, {
  3.559928389259412*^9, 3.5599283910125923`*^9}, {3.5780669684544563`*^9, 
  3.5780669720085487`*^9}, {3.59344945564294*^9, 3.593449457930805*^9}, {
  3.598620628634348*^9, 3.5986206341979733`*^9}, {3.647681504155389*^9, 
  3.647681504516986*^9}}],

Cell["Demo file for ManeParse 1.0 Package Version 2.1", "Title",
 CellChangeTimes->{{3.5383251912910633`*^9, 3.538325202155983*^9}, {
   3.558389402992047*^9, 3.558389405309129*^9}, {3.559664375914991*^9, 
   3.559664375966035*^9}, {3.559666401608172*^9, 3.559666401956048*^9}, {
   3.5599273573613377`*^9, 3.5599273719162607`*^9}, {3.559944921959423*^9, 
   3.559944928762556*^9}, {3.561998086847891*^9, 3.56199809046045*^9}, {
   3.561999111132856*^9, 3.561999114205332*^9}, {3.563217680471964*^9, 
   3.563217682083055*^9}, {3.592241565513515*^9, 3.592241572855503*^9}, {
   3.5939021293360853`*^9, 3.593902148029955*^9}, 3.594829070847901*^9, 
   3.594829127498961*^9, 3.594833572349268*^9, 3.594833628626364*^9, 
   3.594833660533032*^9, {3.594833776808087*^9, 3.594833779638694*^9}, 
   3.594838607731786*^9, {3.601749730225067*^9, 3.601749730891219*^9}, {
   3.620501794224206*^9, 3.620501815512781*^9}, 3.621721812825848*^9, {
   3.635699606575911*^9, 3.635699614423354*^9}, {3.64520731433302*^9, 
   3.645207316583585*^9}, {3.645381627996725*^9, 3.645381654291934*^9}, {
   3.6476815561389236`*^9, 3.6476815597581472`*^9}, 3.6622345554610567`*^9, {
   3.663882580307479*^9, 3.663882592786037*^9}}],

Cell[TextData[{
 "Version 2.1\n19 January 2016\n",
 StyleBox["\nComments and questions to:\n\[LineSeparator]Eric Godat \
egodat@smu.edu\nBen Clark dbclark@smu.edu\nFred Olness olness@physics.smu.edu",
  FontWeight->"Plain"]
}], "Subsection",
 CellChangeTimes->{{3.5383251912910633`*^9, 3.538325202155983*^9}, {
   3.558389402992047*^9, 3.558389405309129*^9}, {3.559663311742455*^9, 
   3.559663314333346*^9}, {3.559945230489336*^9, 3.5599452316643143`*^9}, {
   3.561998101787637*^9, 3.561998134605955*^9}, 3.561998185740478*^9, {
   3.563217165036552*^9, 3.5632171682749968`*^9}, {3.578067883156837*^9, 
   3.578067920498744*^9}, {3.592241578086301*^9, 3.592241588985046*^9}, {
   3.593902156049581*^9, 3.593902156208702*^9}, {3.601749746727882*^9, 
   3.601749767652441*^9}, 3.6019174689723377`*^9, {3.6023591979217777`*^9, 
   3.6023591980812283`*^9}, {3.620501823984877*^9, 3.620501842671781*^9}, {
   3.621721794009934*^9, 3.621721808618557*^9}, {3.6452073202086897`*^9, 
   3.645207332048205*^9}, {3.647680709732994*^9, 3.647680722789303*^9}, {
   3.6476813157481623`*^9, 3.6476813271456203`*^9}, {3.64768136901019*^9, 
   3.647681384159256*^9}, {3.662234551099547*^9, 3.662234569639312*^9}}],

Cell[CellGroupData[{

Cell["Set Directory", "Section",
 CellChangeTimes->{{3.5383251912910633`*^9, 3.538325202155983*^9}, {
  3.558389402992047*^9, 3.558389405309129*^9}, {3.559663311742455*^9, 
  3.559663314333346*^9}, {3.559945230489336*^9, 3.5599452316643143`*^9}, {
  3.561999144885509*^9, 3.561999149486664*^9}, {3.601752053366379*^9, 
  3.6017520544807167`*^9}}],

Cell[CellGroupData[{

Cell["\<\
This example notebook is written with relative directories and is intended to \
be run within the folder extracted from the tarball. Uncomment and modify the \
code below to set a different directory for the LHA files.\
\>", "Subsubsection",
 CellChangeTimes->{{3.6018727099693213`*^9, 3.601872737728833*^9}, 
   3.6018728230318937`*^9, {3.601917488683508*^9, 3.601917494561173*^9}}],

Cell[BoxData[
 RowBox[{"Directory", "[", "]"}]], "Input",
 CellChangeTimes->{{3.633977305468576*^9, 3.633977308971287*^9}, {
  3.633977528414638*^9, 3.6339775285266447`*^9}}],

Cell[BoxData[
 RowBox[{"here", "=", 
  RowBox[{"Directory", "[", "]"}]}]], "Input",
 CellChangeTimes->{{3.633977535633018*^9, 3.633977539430459*^9}, {
   3.645906120475889*^9, 3.645906120774646*^9}, 3.647680786969746*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dirPackages", "=", 
   RowBox[{"here", "<>", "\"\</MP_packages\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dirFilesLHA", "=", 
   RowBox[{"here", "<>", "\"\</PDF_Sets/LHA\>\""}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"dirFilesPDS", "=", 
    RowBox[{"here", "<>", "\"\</PDF_Sets/PDS\>\""}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dirCT10", "=", 
   RowBox[{"dirFilesLHA", "<>", "\"\</CT10\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dirMSTW", "=", 
   RowBox[{"dirFilesLHA", "<>", "\"\</MSTW2008lo68cl\>\""}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dirNNPDF", "=", 
   RowBox[{"dirFilesLHA", "<>", "\"\</NNPDF21_lo_as_0119_100\>\""}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.620567696284552*^9, 3.62056771779727*^9}, {
   3.6216881525920877`*^9, 3.621688212790894*^9}, {3.621688256879899*^9, 
   3.621688293788108*^9}, {3.621706075264311*^9, 3.621706077144305*^9}, {
   3.6326141990797873`*^9, 3.632614227790257*^9}, {3.632614279911984*^9, 
   3.632614287155759*^9}, {3.632614318378047*^9, 3.632614332755554*^9}, {
   3.632614423492887*^9, 3.632614464738666*^9}, 3.632614757268622*^9, {
   3.646150014168021*^9, 3.646150022413168*^9}, {3.6461500526987143`*^9, 
   3.6461500797467813`*^9}, {3.646150133972598*^9, 3.646150151362483*^9}, {
   3.647680806103959*^9, 3.6476808094967117`*^9}, 3.6476810301128607`*^9, {
   3.663888715600375*^9, 3.663888720198051*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"dirCT10pds", " ", "=", " ", 
   RowBox[{"dirFilesPDS", "<>", "\"\</ct10.pds\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dirCTEQ66", " ", "=", " ", 
   RowBox[{"dirFilesPDS", "<>", "\"\</ctq66m.pds\>\""}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6451882163801317`*^9, 3.645188230260705*^9}, {
  3.6451882762238083`*^9, 3.645188342356236*^9}, {3.646150179388092*^9, 
  3.646150185364069*^9}, {3.6470971828370733`*^9, 3.6470971839797993`*^9}}],

Cell[BoxData["dirPackages"], "Input",
 CellChangeTimes->{{3.633977678142871*^9, 3.633977679165757*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Load the package", "Section",
 CellChangeTimes->{{3.5383251912910633`*^9, 3.538325202155983*^9}, {
  3.558389402992047*^9, 3.558389405309129*^9}, {3.559663311742455*^9, 
  3.559663314333346*^9}, {3.559945230489336*^9, 3.5599452316643143`*^9}}],

Cell[CellGroupData[{

Cell["Loading the main package provides many useful functions", \
"Subsubsection",
 CellChangeTimes->{{3.5932656671125526`*^9, 3.5932656939003897`*^9}, 
   3.594838205549959*^9, 3.645207835952182*^9}],

Cell[BoxData[
 RowBox[{"Get", "[", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{"dirPackages", ",", "\"\<pdfParseLHA.m\>\""}], "}"}], "]"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Get", "[", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{"dirPackages", ",", "\"\<pdfParseCTEQ.m\>\""}], "}"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6476819716442842`*^9, 3.64768197347582*^9}}],

Cell[BoxData[
 RowBox[{"Get", "[", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{"dirPackages", ",", "\"\<pdfErrors.m\>\""}], "}"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.647362159843301*^9, 3.647362159848797*^9}, {
  3.647682029920815*^9, 3.647682044784771*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
All functions begin with ' pdf'. To obtain a list of available functions, \
type the command '?pdf*'.\
\>", "Subsubsection",
 CellChangeTimes->{{3.593871832954361*^9, 3.5938719153767357`*^9}, {
  3.601750094965948*^9, 3.601750098047822*^9}}],

Cell[BoxData[
 RowBox[{"?", "pdf*"}]], "Input",
 CellChangeTimes->{{3.5922425067969418`*^9, 3.592242509435423*^9}, {
  3.601750105275565*^9, 3.601750112053944*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Individual file manipulation", "Section",
 CellChangeTimes->{{3.558386799794259*^9, 3.558386802183039*^9}, 
   3.558915004175501*^9, {3.559942298345271*^9, 3.559942309842512*^9}, {
   3.6017515405674753`*^9, 3.601751547596572*^9}}],

Cell[CellGroupData[{

Cell["\<\
Individual files in either LHA or PDS format can be parsed using the \
functions loaded from the packages. Here we demonstrate the LHA parsing \
function\
\>", "Subsubsection",
 CellChangeTimes->{{3.645207920347775*^9, 3.645208016988655*^9}, {
  3.645208048373148*^9, 3.6452080490753098`*^9}}],

Cell[BoxData[
 RowBox[{"?", "pdfParseLHA"}]], "Input",
 CellChangeTimes->{{3.578091943257824*^9, 3.578091952086545*^9}, {
  3.6017503226561747`*^9, 3.6017503248437147`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"datfiles", "=", 
    RowBox[{"FileNames", "[", 
     RowBox[{"\"\<*.dat\>\"", ",", "dirCT10"}], "]"}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "is", " ", "a", " ", "set", " ", "of", " ", "LHA", " ", 
    "PDFs"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"infofile", "=", 
    RowBox[{"FileNames", "[", 
     RowBox[{"\"\<*.info\>\"", ",", "dirCT10"}], "]"}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "is", " ", "the", " ", "associated", " ", "info", " ", 
    "file"}], " ", "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5939033831237793`*^9, 3.59390338426035*^9}, {
  3.601750378929574*^9, 3.6017505229822807`*^9}, {3.620502179394185*^9, 
  3.620502188892807*^9}, {3.645208114279232*^9, 3.645208192985732*^9}}],

Cell[BoxData[
 RowBox[{"sample", "=", 
  RowBox[{"pdfParseLHA", "[", 
   RowBox[{
    RowBox[{"infofile", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"datfiles", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.558389195107996*^9, 3.558389196372877*^9}, {
   3.558389482691423*^9, 3.558389486708326*^9}, {3.559663348374937*^9, 
   3.559663349181538*^9}, {3.559663773040453*^9, 3.559663787125555*^9}, {
   3.559928275275425*^9, 3.5599282753226213`*^9}, {3.559929259185066*^9, 
   3.559929259800253*^9}, {3.578068308904389*^9, 3.5780683212583027`*^9}, {
   3.57972984294201*^9, 3.5797298442171373`*^9}, {3.601750567470752*^9, 
   3.6017506055686913`*^9}, 3.601750661517353*^9, {3.632615172174108*^9, 
   3.632615184491791*^9}}],

Cell[BoxData[
 RowBox[{"sample2", "=", 
  RowBox[{"pdfParseLHA", "[", 
   RowBox[{
    RowBox[{"infofile", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", 
    RowBox[{"datfiles", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.558389473897577*^9, 3.558389489441855*^9}, {
  3.559663351739863*^9, 3.55966335231432*^9}, {3.559928290443873*^9, 
  3.559928290931899*^9}, {3.559929263885853*^9, 3.559929266540743*^9}, {
  3.5780683264714737`*^9, 3.578068330727437*^9}, {3.601750671886283*^9, 
  3.601750692762535*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Calling the pdfSetList variable will give a key to the data files in memory. \
The information is displayed as:
{SetNumber,FileName, maxFlavor, numberValence}\
\>", "Subsubsection",
 CellChangeTimes->{{3.559929100484604*^9, 3.5599291369702*^9}, {
  3.5780683970677977`*^9, 3.578068404066022*^9}, {3.593903607960786*^9, 
  3.593903679872466*^9}, {3.601750896561644*^9, 3.60175090371681*^9}, {
  3.620502243761203*^9, 3.620502268556006*^9}, {3.645207877247024*^9, 
  3.645207881057626*^9}, {3.6452080697475758`*^9, 3.6452080833499737`*^9}}],

Cell[BoxData[
 RowBox[{"pdfSetList", "//", "TableForm"}]], "Input",
 CellChangeTimes->{{3.559661782998003*^9, 3.559661789849975*^9}, {
   3.559663370550331*^9, 3.5596633731671124`*^9}, {3.578068675951004*^9, 
   3.578068676543491*^9}, {3.593265802875122*^9, 3.593265803961055*^9}, {
   3.601750705628868*^9, 3.601750706143149*^9}, 3.620502212098131*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Files can be added to memory without a name. All files can be called by their \
set numbers.\
\>", "Subsubsection",
 CellChangeTimes->{{3.559929157494142*^9, 3.559929190377808*^9}, {
   3.55992942858841*^9, 3.559929431468669*^9}, {3.578068425936318*^9, 
   3.5780684272172747`*^9}, {3.593903724205701*^9, 3.593903763406414*^9}, {
   3.594827732637505*^9, 3.594827763801659*^9}, 3.594838212909867*^9, 
   3.601917571550778*^9}],

Cell[BoxData[
 RowBox[{"pdfParseLHA", "[", 
  RowBox[{
   RowBox[{"infofile", "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", 
   RowBox[{"datfiles", "[", 
    RowBox[{"[", "3", "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5599292013336773`*^9, 3.559929241257432*^9}, {
  3.57806847529207*^9, 3.578068475375802*^9}, {3.578068683097766*^9, 
  3.578068683491393*^9}, {3.5780688747430677`*^9, 3.578068891349654*^9}, {
  3.578068988345955*^9, 3.578068995364237*^9}, {3.578091040962435*^9, 
  3.5780910426912394`*^9}, {3.578091990238678*^9, 3.578091991910532*^9}, {
  3.593903711550473*^9, 3.593903715261476*^9}, {3.6017507248581247`*^9, 
  3.6017507445115337`*^9}, {3.60175079870619*^9, 3.601750828853676*^9}}],

Cell[BoxData[
 RowBox[{"pdfSetList", "//", "TableForm"}]], "Input",
 CellChangeTimes->{{3.558914284456826*^9, 3.558914287056069*^9}, {
  3.5596618168961153`*^9, 3.559661822998934*^9}, {3.575653611819236*^9, 
  3.575653612392091*^9}, {3.5932658316582193`*^9, 3.593265832571904*^9}, {
  3.60175085095541*^9, 3.6017508514364223`*^9}, {3.6205022329759502`*^9, 
  3.6205022334200163`*^9}}]
}, Open  ]],

Cell["\<\
Open and parse single files in any order. You may assign names to each pdf \
set. Each PDF set is identified by a SetNumber.\
\>", "Subsubsection",
 CellChangeTimes->{{3.558914339761585*^9, 3.5589143656335907`*^9}, {
  3.559928451436133*^9, 3.559928510013825*^9}, {3.578068352746889*^9, 
  3.578068387140251*^9}, {3.5780685722358913`*^9, 3.578068579191424*^9}, {
  3.5939035258364143`*^9, 3.593903558780776*^9}, {3.5939036440588627`*^9, 
  3.59390364422824*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Batch file manipulation", "Section",
 CellChangeTimes->{{3.537136219210054*^9, 3.537136256951696*^9}, {
  3.558387712640037*^9, 3.558387713910541*^9}, {3.559662043016856*^9, 
  3.559662053456148*^9}, {3.559942285936569*^9, 3.5599422925963287`*^9}, {
  3.5780911148174877`*^9, 3.5780911227056217`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Resetting memory can be accomplished with the pdfReset command.\
\>", "Subsubsection",
 CellChangeTimes->{{3.559929640158946*^9, 3.559929685670115*^9}, 
   3.594838216192356*^9, {3.601917605480023*^9, 3.601917607112062*^9}, 
   3.645208307328948*^9}],

Cell[BoxData[
 RowBox[{"pdfReset", "[", "]"}]], "Input",
 CellChangeTimes->{{3.559929631194358*^9, 3.559929633052493*^9}, {
   3.593265842843758*^9, 3.593265842961874*^9}, {3.593903797180538*^9, 
   3.593903807375154*^9}, {3.601750861458146*^9, 3.601750863104463*^9}, {
   3.620502274892385*^9, 3.620502276169774*^9}, 3.6326148897226467`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["The set list is now empty.", "Subsubsection",
 CellChangeTimes->{{3.5780911501611967`*^9, 3.57809116662111*^9}, {
  3.5795761210191174`*^9, 3.5795761230477657`*^9}}],

Cell[BoxData[
 RowBox[{"pdfSetList", " ", "//", "TableForm"}]], "Input",
 CellChangeTimes->{{3.559662497479479*^9, 3.559662511225165*^9}, {
   3.601751037093652*^9, 3.601751037535308*^9}, 3.6205022828894043`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The pdfFamilyParseLHA command can be used to store a family of LHA info and \
dat files in memory. The function returns a list of values that can be \
associated with the family.\
\>", "Subsubsection",
 CellChangeTimes->{{3.559929705474958*^9, 3.559929772834249*^9}, {
  3.55994308573*^9, 3.5599431464396677`*^9}, {3.578091277731194*^9, 
  3.57809132285772*^9}, {3.5780913965748796`*^9, 3.578091452150324*^9}, {
  3.593903925306288*^9, 3.593903947979961*^9}, {3.60191761770044*^9, 
  3.601917638484899*^9}}],

Cell[BoxData[
 RowBox[{"?", "pdfFamilyParseLHA"}]], "Input",
 CellChangeTimes->{{3.578091914110283*^9, 3.5780919216518917`*^9}, {
  3.60175104436231*^9, 3.601751044914218*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
First we import the ct10 dat files. The family will include the info file, \
the central value(set #1) and 52 eigenvector error sets. The family name can \
be defined at this point.\
\>", "Subsubsection",
 CellChangeTimes->{{3.5780928798686943`*^9, 3.578092884799884*^9}, {
  3.578092927240342*^9, 3.57809303802133*^9}, {3.5932659103824263`*^9, 
  3.5932659261451683`*^9}, {3.594838219364202*^9, 3.594838229341335*^9}, {
  3.6017510911743107`*^9, 3.6017510914520063`*^9}, {3.6017511592859488`*^9, 
  3.601751181829934*^9}, {3.6017516619893217`*^9, 3.6017516708275414`*^9}}],

Cell[BoxData[
 RowBox[{"ct10", "=", 
  RowBox[{"pdfFamilyParseLHA", "[", 
   RowBox[{"dirCT10", ",", "\"\<*.dat\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5760187680843277`*^9, 3.5760187693926973`*^9}, {
  3.5780915554103518`*^9, 3.578091575262548*^9}, {3.5780916466376057`*^9, 
  3.57809165686948*^9}, {3.578092143690236*^9, 3.578092144320158*^9}, {
  3.578093047493392*^9, 3.578093107943511*^9}, {3.59326592985148*^9, 
  3.593265932054998*^9}, {3.601751103245487*^9, 3.6017511244879217`*^9}, {
  3.620502297619299*^9, 3.620502303859071*^9}, {3.632615084507722*^9, 
  3.63261511983711*^9}, {3.632618920086047*^9, 3.632618921426249*^9}, {
  3.663263288751699*^9, 3.663263291374094*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Test PDFs", "Section",
 CellChangeTimes->{{3.537136219210054*^9, 3.537136256951696*^9}, {
   3.558387712640037*^9, 3.558387713910541*^9}, 3.645193035758833*^9}],

Cell[CellGroupData[{

Cell[TextData[{
 "The function \[OpenCurlyDoubleQuote]pdf\[CloseCurlyDoubleQuote] is left to \
be defined by the user. Access to the PDF of the set is given by pdfFunction. \
The function has the canonical form: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["pdfFunction", "Input"], 
    StyleBox["[", "Input"], 
    StyleBox[
     RowBox[{"setNumber", ",", "flavorNumber", ",", "x", ",", "Q"}], "Input"],
     "]"}], TraditionalForm]]],
 ".  If the function is not defined, pdfFunction returns ",
 StyleBox["NULL", "Input"],
 "."
}], "Subsubsection",
 CellChangeTimes->{{3.5599448245149727`*^9, 3.5599448865008307`*^9}, {
   3.593904335921968*^9, 3.593904425836418*^9}, {3.593904564438365*^9, 
   3.593904636684328*^9}, {3.5939047365116053`*^9, 3.5939047378660583`*^9}, {
   3.593911450706306*^9, 3.593911451032343*^9}, {3.594833810117793*^9, 
   3.594833838553198*^9}, 3.594838234825098*^9, {3.601917701719339*^9, 
   3.6019177023757343`*^9}, 3.64519303576056*^9, 3.645208385756384*^9}],

Cell[BoxData[
 RowBox[{"?", "pdfFunction"}]], "Input",
 CellChangeTimes->{{3.578094356370653*^9, 3.578094367067339*^9}, {
   3.592251739492003*^9, 3.59225174378172*^9}, {3.592256594307105*^9, 
   3.592256595639389*^9}, {3.601751289631068*^9, 3.601751290185082*^9}, {
   3.632616928298539*^9, 3.6326169285671043`*^9}, 3.645193035761043*^9}],

Cell[BoxData[
 RowBox[{"pdfFunction", "[", 
  RowBox[{"1", ",", "1", ",", ".1", ",", "10"}], "]"}]], "Input",
 CellChangeTimes->{{3.592251774979146*^9, 3.592251802377573*^9}, 
   3.59225212516621*^9, {3.592252756909343*^9, 3.592252796048566*^9}, {
   3.592252862015884*^9, 3.592252869235325*^9}, {3.592253515389323*^9, 
   3.592253518183917*^9}, {3.59225430903328*^9, 3.59225430984164*^9}, {
   3.592256603284144*^9, 3.592256617995723*^9}, {3.592256839816321*^9, 
   3.592256846091628*^9}, {3.5922591076838417`*^9, 3.5922591105930347`*^9}, {
   3.592261958580059*^9, 3.592261960074806*^9}, {3.5932659957577353`*^9, 
   3.593266006973802*^9}, {3.601751294635931*^9, 3.601751295236204*^9}, {
   3.632614993532839*^9, 3.632614993894493*^9}, 3.6451930357622013`*^9, {
   3.646151668993538*^9, 3.646151673151718*^9}, {3.66326321857651*^9, 
   3.663263219826548*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "pdf", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pdf", "[", 
   RowBox[{
    RowBox[{"iset_", "?", "IntegerQ"}], ",", 
    RowBox[{"ipart_", "?", "IntegerQ"}], ",", 
    RowBox[{"x_", "?", "NumericQ"}], ",", 
    RowBox[{"q_", "?", "NumericQ"}]}], "]"}], ":=", 
  RowBox[{"pdfFunction", "[", 
   RowBox[{"iset", ",", "ipart", ",", "x", ",", "q"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.559664527889824*^9, 3.55966455919501*^9}, {
   3.5596645934935503`*^9, 3.559664596482181*^9}, {3.5599429030254517`*^9, 
   3.559942905780265*^9}, {3.563216903599263*^9, 3.5632169136662617`*^9}, 
   3.56321722970466*^9, {3.566746500520062*^9, 3.566746541416832*^9}, {
   3.575653846415822*^9, 3.575653847615641*^9}, {3.5795748178496647`*^9, 
   3.579574843368395*^9}, {3.592250755779875*^9, 3.592250757935133*^9}, {
   3.593266590947604*^9, 3.593266593826728*^9}, {3.5932666239856157`*^9, 
   3.593266685556769*^9}, {3.60175158254762*^9, 3.601751583080552*^9}, 
   3.632616971250416*^9, 3.64519303576269*^9}],

Cell[BoxData[{
 RowBox[{"pdf", "[", 
  RowBox[{"1", ",", "1", ",", ".1", ",", "10"}], "]"}], "\n", 
 RowBox[{
  RowBox[{"pdf", "[", 
   RowBox[{"2", ",", "1", ",", "0.1", ",", "10"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"centralvalue", " ", "=", " ", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"pdf", "[", 
  RowBox[{"centralvalue", ",", "1", ",", "0.1", ",", "10"}], "]"}]}], "Input",\

 CellChangeTimes->{{3.575654018449548*^9, 3.57565402969004*^9}, 
   3.5932666115108147`*^9, {3.59390475566858*^9, 3.593904761070496*^9}, {
   3.5939088355730762`*^9, 3.593908838926797*^9}, {3.6017516408866653`*^9, 
   3.601751688603477*^9}, 3.6451930357637043`*^9, {3.645208916134046*^9, 
   3.645208930323936*^9}}]
}, Open  ]],

Cell["Check Timing :", "Subsection",
 CellChangeTimes->{{3.645906484207472*^9, 3.645906488832973*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"pdf", "[", 
      RowBox[{"iset0", ",", "0", ",", 
       RowBox[{"RandomReal", "[", "]"}], ",", "10."}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "1000"}], "}"}]}], "]"}], "  ", "//", 
   "Timing"}], " ", "//", "First"}]], "Input",
 CellChangeTimes->{{3.645906350627459*^9, 3.64590644737241*^9}, {
   3.6459065444631033`*^9, 3.645906551195909*^9}, 3.645907233496592*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"pdf", "[", 
      RowBox[{"iset0", ",", "0", ",", 
       RowBox[{"1", "/", "i"}], ",", "10."}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1.", ",", "1000"}], "}"}]}], "]"}], "  ", "//", 
   "Timing"}], " ", "//", "First"}]], "Input",
 CellChangeTimes->{{3.645906350627459*^9, 3.64590644737241*^9}, {
   3.645906506977302*^9, 3.645906521365028*^9}, {3.6459065690107183`*^9, 
   3.645906573630746*^9}, 3.645907237661343*^9}],

Cell[CellGroupData[{

Cell["Check sum rule:", "Subsubsection",
 CellChangeTimes->{{3.55838969078966*^9, 3.558389705520049*^9}, {
   3.5599433920286007`*^9, 3.559943405337268*^9}, {3.578094482321333*^9, 
   3.5780944985775747`*^9}, 3.6017517105076313`*^9, 3.645193035769907*^9}],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"NIntegrate", "::", "izero"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q0", "=", "2.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"iset0", "=", "1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.558388176662824*^9, 3.558388237585742*^9}, {
   3.558388316374671*^9, 3.558388339130072*^9}, {3.558877222312537*^9, 
   3.558877222411696*^9}, 3.558914951117453*^9, 3.558916269097796*^9, {
   3.559663948356461*^9, 3.559664003410111*^9}, 3.559943258309353*^9, {
   3.593266820949542*^9, 3.5932668317122517`*^9}, 3.593904688611562*^9, {
   3.5948366962967*^9, 3.594836697605308*^9}, {3.594836836164318*^9, 
   3.594836854014057*^9}, 3.594836918672712*^9, 3.601752014609395*^9, {
   3.645188602471499*^9, 3.6451886025211983`*^9}, 3.6451930357701893`*^9, 
   3.645208836812763*^9, {3.645906401325358*^9, 3.645906404870267*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"This", " ", "can", " ", "take", " ", "a", " ", "while"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"tab", "=", " ", 
      RowBox[{"Table", "[", " ", 
       RowBox[{
        RowBox[{"NIntegrate", "[", " ", 
         RowBox[{
          RowBox[{"x", " ", 
           RowBox[{"pdf", "[", 
            RowBox[{"iset0", ",", "ipart", ",", "x", ",", "q0"}], "]"}]}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ipart", ",", 
          RowBox[{"-", "5"}], ",", "5", ",", "1"}], "}"}]}], "]"}]}], ";"}], "//",
     "Timing"}], "\[IndentingNewLine]", 
   RowBox[{"Plus", " ", "@@", " ", "tab"}]}]}]], "Input",
 CellChangeTimes->{{3.594837134140593*^9, 3.594837135493274*^9}, {
   3.601751751037738*^9, 3.601751752971987*^9}, 3.601752278398031*^9, {
   3.6326207495695143`*^9, 3.632620750524805*^9}, 3.635701610608427*^9, 
   3.637579731131372*^9, 3.645193035771167*^9, {3.645906330340806*^9, 
   3.645906341253851*^9}, {3.646151807531912*^9, 3.646151808840701*^9}, {
   3.64615208576266*^9, 3.646152114483816*^9}, {3.646152145103991*^9, 
   3.6461521498397293`*^9}, 3.6461523760050507`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"flavorlist", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.601752882211306*^9, 3.6017528887835417`*^9}, {
   3.6017534889266443`*^9, 3.601753489856092*^9}, 3.601753646443508*^9, {
   3.6017538512802343`*^9, 3.601753858127514*^9}, 3.645193035772922*^9}],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", 
    RowBox[{"-", "5"}]}], ",", 
   RowBox[{"i", "\[LessEqual]", "5"}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{
    RowBox[{"AppendTo", "[", 
     RowBox[{"flavorlist", ",", 
      RowBox[{"pdfFlavor", "[", "i", "]"}]}], "]"}], ";"}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.601753610123262*^9, 3.601753643329199*^9}, {
   3.601753677793241*^9, 3.601753679638341*^9}, {3.601753747801209*^9, 
   3.601753756136877*^9}, {3.60175378894305*^9, 3.60175384772458*^9}, 
   3.620503230549233*^9, {3.632853466181031*^9, 3.632853470753668*^9}, 
   3.63757999765338*^9, 3.645193035773881*^9}],

Cell[BoxData["flavorlist"], "Input",
 CellChangeTimes->{{3.601752562361206*^9, 3.60175257031732*^9}, {
   3.601752741521762*^9, 3.60175278027628*^9}, {3.6017528539062347`*^9, 
   3.6017528760288897`*^9}, {3.601752919973709*^9, 3.601752920071772*^9}, {
   3.6017530092084923`*^9, 3.6017530353146353`*^9}, {3.6017534746600924`*^9, 
   3.601753482951816*^9}, {3.601753653966588*^9, 3.601753657192586*^9}, {
   3.6017538679503736`*^9, 3.601753869045025*^9}, 3.6451930357748003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "flavorlist", ",", 
     RowBox[{"Round", "[", 
      RowBox[{"100", " ", "tab"}], "]"}]}], "}"}], " ", "//", "Transpose"}], 
  " ", "//", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], "&"}]}]], "Input",
 CellChangeTimes->{{3.594837426000315*^9, 3.594837512743508*^9}, {
   3.594837550221739*^9, 3.594837550940566*^9}, {3.59483763237888*^9, 
   3.594837708593923*^9}, {3.594837752075708*^9, 3.594837786565183*^9}, {
   3.601751798344823*^9, 3.601751811639182*^9}, {3.601753056194503*^9, 
   3.601753063082972*^9}, {3.6017531033184557`*^9, 3.601753103783552*^9}, 
   3.601753452524457*^9, {3.601753873217416*^9, 3.60175387477721*^9}, 
   3.645193035776854*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example: Plotting  Single Functions", "Section",
 CellChangeTimes->{{3.537136219210054*^9, 3.537136256951696*^9}, {
   3.558387712640037*^9, 3.558387713910541*^9}, {3.558914984760498*^9, 
   3.558914997261568*^9}, {3.593905781407874*^9, 3.593905788523736*^9}, {
   3.594833948323166*^9, 3.594833955347286*^9}, 3.594834019338334*^9}],

Cell[CellGroupData[{

Cell["First we find the minimum value of x for our pdf family. ", \
"Subsubsection",
 CellChangeTimes->{{3.578094880286613*^9, 3.578094920551873*^9}, {
   3.578094973528982*^9, 3.57809499395787*^9}, {3.578095545999968*^9, 
   3.578095582173026*^9}, 3.5939055356007023`*^9}],

Cell[BoxData[
 RowBox[{"?", "pdfXmin"}]], "Input",
 CellChangeTimes->{{3.5780955880010853`*^9, 3.578095590900298*^9}, {
  3.601754879828714*^9, 3.601754880569543*^9}, {3.62050325679961*^9, 
  3.620503257387616*^9}}],

Cell[BoxData[
 RowBox[{"xMin", "=", 
  RowBox[{"pdfXmin", "[", "1", "]"}]}]], "Input",
 CellChangeTimes->{{3.593905102502877*^9, 3.593905110941955*^9}, {
   3.593905543440345*^9, 3.59390554923766*^9}, 3.594826551869941*^9, {
   3.601754959253501*^9, 3.601754959965331*^9}, 3.601754999999446*^9, {
   3.620503261933874*^9, 3.620503263900703*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We will produce plots of x*pdf(x,Q) for all  flavors with the central value \
in red and the first error set in green. The flavor can be called with the \
command pdfFlavor[flavor]. \
\>", "Subsubsection",
 CellChangeTimes->{{3.578094880286613*^9, 3.578094920551873*^9}, {
  3.578094973528982*^9, 3.57809499395787*^9}, {3.578095545999968*^9, 
  3.578095582173026*^9}, {3.578095613781921*^9, 3.578095715100192*^9}, {
  3.578164147247816*^9, 3.578164151352611*^9}, {3.593905131761115*^9, 
  3.593905162063147*^9}, {3.6019178279276733`*^9, 3.6019178601873302`*^9}, {
  3.6452089567758427`*^9, 3.645208968240361*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"q0", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"centralvalue", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"errorvalue", "=", "2"}], ";"}]}], "Input",
 CellChangeTimes->{{3.558389298043715*^9, 3.558389383441816*^9}, {
   3.558389771118386*^9, 3.558389887362409*^9}, {3.5588770710473022`*^9, 
   3.558877079936973*^9}, {3.558877133107316*^9, 3.5588771570432997`*^9}, {
   3.558877187813177*^9, 3.558877188701536*^9}, {3.558915052449852*^9, 
   3.5589151055242443`*^9}, {3.559944477956419*^9, 3.559944479821953*^9}, {
   3.561902017541214*^9, 3.5619020184453697`*^9}, {3.561903548503592*^9, 
   3.56190354859699*^9}, {3.56199737366618*^9, 3.561997378465881*^9}, {
   3.561998044348396*^9, 3.561998044777002*^9}, {3.563555573300335*^9, 
   3.563555583719665*^9}, 3.563555657692699*^9, {3.563573340109346*^9, 
   3.563573343230054*^9}, {3.563574248658873*^9, 3.563574253801478*^9}, {
   3.578094828654139*^9, 3.578094872242288*^9}, {3.578095095624116*^9, 
   3.578095139310384*^9}, {3.5808405966204853`*^9, 3.58084060222915*^9}, {
   3.5884233722576313`*^9, 3.58842337244928*^9}, {3.593266905674479*^9, 
   3.593266925143467*^9}, {3.593905173199896*^9, 3.593905211033351*^9}, {
   3.593905248892988*^9, 3.593905274763945*^9}, {3.593905555693705*^9, 
   3.593905634637241*^9}, {3.5939058286962433`*^9, 3.5939058385207*^9}, {
   3.593905928455616*^9, 3.5939060757552958`*^9}, {3.593906140461885*^9, 
   3.5939061515200653`*^9}, {3.593906209324853*^9, 3.593906278379835*^9}, {
   3.593906344245811*^9, 3.5939064547517757`*^9}, {3.5939064958715563`*^9, 
   3.593906505812154*^9}, {3.5939066125030603`*^9, 3.593906667535852*^9}, {
   3.593906704457993*^9, 3.5939067116273317`*^9}, {3.5939088735479317`*^9, 
   3.593908887249167*^9}, {3.593911382007868*^9, 3.593911391696353*^9}, {
   3.594051854989216*^9, 3.5940518550640497`*^9}, {3.594051892673172*^9, 
   3.5940518927580967`*^9}, {3.5940520019712*^9, 3.5940520036123657`*^9}, 
   3.594826556092084*^9, {3.594826612147106*^9, 3.594826626231467*^9}, {
   3.594826735521295*^9, 3.594826771077426*^9}, {3.594826943777868*^9, 
   3.594826944896225*^9}, {3.594827051058401*^9, 3.594827141590041*^9}, {
   3.594827186402011*^9, 3.594827202637112*^9}, {3.594827249277203*^9, 
   3.594827249616434*^9}, {3.594833698062989*^9, 3.594833698359328*^9}, {
   3.601755056265823*^9, 3.6017551266888237`*^9}, {3.601755170403851*^9, 
   3.601755176145411*^9}, 3.601755859698276*^9, {3.601756008485155*^9, 
   3.601756014374342*^9}, {3.601869381317051*^9, 3.6018693817210197`*^9}, 
   3.632621077883027*^9, 3.6327686889286413`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", 
     RowBox[{"-", "5"}]}], ",", 
    RowBox[{"i", "\[LessEqual]", "5"}], ",", 
    RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"LogLinearPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"pdf", "[", 
            RowBox[{"errorvalue", ",", "i", ",", "x", ",", "q0"}], "]"}], ",", 
           RowBox[{"pdf", "[", 
            RowBox[{"centralvalue", ",", "i", ",", "x", ",", "q0"}], "]"}]}], 
          "}"}]}], "//", "Evaluate"}], " ", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"xMin", "*", "100"}], ",", "1"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Directive", "[", 
           RowBox[{"Red", ",", "Thick"}], "]"}], ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Green", ",", "Thick"}], "]"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotLabel", "\[Rule]", 
        RowBox[{"pdfFlavor", "[", "i", "]"}]}], " ", ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", "\"\<x*pdf[x]\>\""}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "\[Rule]", 
        RowBox[{"Placed", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<error\>\"", ",", "\"\<central\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.1", ",", "0.18"}], "}"}]}], "]"}]}]}], "]"}], " ", "//",
      "Print"}]}], "\[IndentingNewLine]", "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.558389298043715*^9, 3.558389383441816*^9}, {
   3.558389771118386*^9, 3.558389887362409*^9}, {3.5588770710473022`*^9, 
   3.558877079936973*^9}, {3.558877133107316*^9, 3.5588771570432997`*^9}, {
   3.558877187813177*^9, 3.558877188701536*^9}, {3.558915052449852*^9, 
   3.5589151055242443`*^9}, {3.559944477956419*^9, 3.559944479821953*^9}, {
   3.561902017541214*^9, 3.5619020184453697`*^9}, {3.561903548503592*^9, 
   3.56190354859699*^9}, {3.56199737366618*^9, 3.561997378465881*^9}, {
   3.561998044348396*^9, 3.561998044777002*^9}, {3.563555573300335*^9, 
   3.563555583719665*^9}, 3.563555657692699*^9, {3.563573340109346*^9, 
   3.563573343230054*^9}, {3.563574248658873*^9, 3.563574253801478*^9}, {
   3.578094828654139*^9, 3.578094872242288*^9}, {3.578095095624116*^9, 
   3.578095139310384*^9}, {3.5808405966204853`*^9, 3.58084060222915*^9}, {
   3.5884233722576313`*^9, 3.58842337244928*^9}, {3.593266905674479*^9, 
   3.593266925143467*^9}, {3.593905173199896*^9, 3.593905211033351*^9}, {
   3.593905248892988*^9, 3.593905274763945*^9}, {3.593905555693705*^9, 
   3.593905634637241*^9}, {3.5939058286962433`*^9, 3.5939058385207*^9}, {
   3.593905928455616*^9, 3.5939060757552958`*^9}, {3.593906140461885*^9, 
   3.5939061515200653`*^9}, {3.593906209324853*^9, 3.593906278379835*^9}, {
   3.593906344245811*^9, 3.5939064547517757`*^9}, {3.5939064958715563`*^9, 
   3.593906505812154*^9}, {3.5939066125030603`*^9, 3.593906667535852*^9}, {
   3.593906704457993*^9, 3.5939067116273317`*^9}, {3.5939088735479317`*^9, 
   3.593908887249167*^9}, {3.593911382007868*^9, 3.593911391696353*^9}, {
   3.594051854989216*^9, 3.5940518550640497`*^9}, {3.594051892673172*^9, 
   3.5940518927580967`*^9}, {3.5940520019712*^9, 3.5940520036123657`*^9}, 
   3.594826556092084*^9, {3.594826612147106*^9, 3.594826626231467*^9}, {
   3.594826735521295*^9, 3.594826771077426*^9}, {3.594826943777868*^9, 
   3.594826944896225*^9}, {3.594827051058401*^9, 3.594827141590041*^9}, {
   3.594827186402011*^9, 3.594827202637112*^9}, {3.594827249277203*^9, 
   3.594827249616434*^9}, {3.594833698062989*^9, 3.594833698359328*^9}, {
   3.601755056265823*^9, 3.6017551266888237`*^9}, {3.601755170403851*^9, 
   3.601755176145411*^9}, 3.601755859698276*^9, {3.601756533485606*^9, 
   3.601756536109228*^9}, {3.601868771085828*^9, 3.601868777043646*^9}, {
   3.6018689973249693`*^9, 3.601869035318097*^9}, {3.601869135075268*^9, 
   3.601869192741187*^9}, 3.620503273121613*^9, 3.632853360308758*^9, 
   3.633281585592968*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example: Plotting  Band Plots", "Section",
 CellChangeTimes->{{3.537136219210054*^9, 3.537136256951696*^9}, {
  3.558387712640037*^9, 3.558387713910541*^9}, {3.558914984760498*^9, 
  3.558914997261568*^9}, {3.593905781407874*^9, 3.593905788523736*^9}, {
  3.594833948323166*^9, 3.594833955347286*^9}, {3.594833994650249*^9, 
  3.59483401173473*^9}}],

Cell[CellGroupData[{

Cell["Band plots can be created to compare any group of PDF sets.", \
"Subsubsection",
 CellChangeTimes->{{3.5780957650219793`*^9, 3.578095868286147*^9}, {
   3.578095990426145*^9, 3.5780960162878523`*^9}, {3.593905341232664*^9, 
   3.5939053415615377`*^9}, {3.593905658244752*^9, 3.5939056588184566`*^9}, 
   3.601917397909203*^9}],

Cell[BoxData["ct10"], "Input",
 CellChangeTimes->{{3.601870032936592*^9, 3.601870034906514*^9}}],

Cell[BoxData[
 RowBox[{"length", "=", 
  RowBox[{"ct10", " ", "//", "Length"}]}]], "Input",
 CellChangeTimes->{{3.561997449844531*^9, 3.561997459223268*^9}, {
  3.578095878042276*^9, 3.578095878653844*^9}, {3.593266959151383*^9, 
  3.593266965877372*^9}, {3.5939056613649817`*^9, 3.593905662865182*^9}, {
  3.6018700441381083`*^9, 3.60187004538039*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "The", " ", "following", " ", "function", " ", "has", " ", "been", " ", 
    "designed", " ", "to", " ", "create", " ", "a", " ", "LogLinear", " ", 
    "Plot", " ", "and", " ", "modified", " ", "for", " ", "appearance", " ", 
    "sake"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"LHAplot", "[", 
      RowBox[{
       RowBox[{"iset_", "?", "IntegerQ"}], ",", 
       RowBox[{"ipart_", "?", "IntegerQ"}], ",", "q_"}], "]"}], ":=", 
     "\[IndentingNewLine]", 
     RowBox[{"LogLinearPlot", "[", 
      RowBox[{
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{"pdf", "[", 
          RowBox[{"iset", ",", "ipart", ",", "x", ",", "q"}], "]"}], ")"}]}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"10", "^", 
          RowBox[{"-", "3"}]}], ",", "0.9"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Hue", "[", 
         RowBox[{"iset", "/", "length"}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", "\"\<x*pdf[x]\>\""}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotLabel", "\[Rule]", 
        RowBox[{"pdfFlavor", "[", "ipart", "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
   "\n"}]}]], "Input",
 CellChangeTimes->{{3.6452090943997707`*^9, 3.645209172665506*^9}, 
   3.645209366718601*^9}],

Cell[BoxData[
 RowBox[{"LHAplot", "[", 
  RowBox[{"1", ",", "1", ",", "1.3"}], "]"}]], "Input",
 CellChangeTimes->{{3.6205048682661867`*^9, 3.620504903547254*^9}, {
  3.6205050063081093`*^9, 3.620505014216806*^9}, {3.6326200921017437`*^9, 
  3.632620097687519*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ipart", "=", "0"}], ";"}], " ", 
  RowBox[{"(*", " ", "gluon", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q0", "=", "1.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bandplot", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"LHAplot", "[", 
      RowBox[{"i", ",", "ipart", ",", "q0"}], "]"}], " ", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"ct10", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "length"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{"bandplot", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.558915742802106*^9, 3.558915742804029*^9}, {
   3.558915796151528*^9, 3.558915799616222*^9}, 3.558915890489921*^9, {
   3.5589159542664347`*^9, 3.558915956403607*^9}, {3.558916024262493*^9, 
   3.55891607882733*^9}, {3.559664114366496*^9, 3.559664120389502*^9}, {
   3.559664163634136*^9, 3.5596642011948013`*^9}, {3.559944513464335*^9, 
   3.55994459962263*^9}, {3.5599446995031843`*^9, 3.559944750140936*^9}, {
   3.559945334796378*^9, 3.5599453350562553`*^9}, {3.59326703105937*^9, 
   3.5932670855256*^9}, {3.594827368358795*^9, 3.594827373213769*^9}, {
   3.601870076181686*^9, 3.601870091755403*^9}, 3.620506411445849*^9, {
   3.632620040725172*^9, 3.632620040840826*^9}, 3.6327687508596087`*^9, 
   3.632853343960807*^9, 3.6332815928731403`*^9, {3.645209453221743*^9, 
   3.645209458795517*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ipart", "=", "1"}], ";"}], " ", 
   RowBox[{"(*", " ", "down", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"q0", "=", "1.3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bandplot", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"LHAplot", "[", 
        RowBox[{"i", ",", "ipart", ",", "q0"}], "]"}], " ", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"ct10", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "length"}], "}"}]}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{"Show", "[", 
    RowBox[{"bandplot", ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.601916920828122*^9, 3.6019169613489523`*^9}, {
   3.6019170140176687`*^9, 3.601917025046666*^9}, {3.601917057653081*^9, 
   3.601917089645688*^9}, {3.6019172011771708`*^9, 3.6019172472990427`*^9}, {
   3.620506441587268*^9, 3.6205064471592827`*^9}, {3.62050647759088*^9, 
   3.620506477656146*^9}, {3.632768782554545*^9, 3.632768782969047*^9}, 
   3.6328533402921343`*^9, 3.633281597478879*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example : Ratio Plots", "Section",
 CellChangeTimes->{{3.602358038787328*^9, 3.6023580552971*^9}}],

Cell[CellGroupData[{

Cell["\<\
This compares a value for the same initial variables across all the PDFs in a \
family\
\>", "Subsubsection",
 CellChangeTimes->{{3.602358791615847*^9, 3.602358905276664*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"q0", "=", "10."}], ";"}]], "Input",
 CellChangeTimes->{{3.602358081730144*^9, 3.6023580845932198`*^9}, {
  3.602358930964926*^9, 3.602358963362969*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pdfFunction", "[", 
    RowBox[{"#", ",", " ", "21", ",", " ", "0.1", ",", " ", "q0"}], "]"}], 
   " ", "&"}], " ", "/@", " ", "ct10"}]], "Input",
 CellChangeTimes->{{3.6023580710639753`*^9, 3.602358071355966*^9}, {
  3.60235891997946*^9, 3.602358925786207*^9}, {3.632619152860951*^9, 
  3.632619153394047*^9}, {3.63261938515891*^9, 3.6326193853104773`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Here all the PDFs in the family are compared to the central value PDF\
\>", "Subsubsection",
 CellChangeTimes->{{3.602358987038128*^9, 3.602359048235284*^9}}],

Cell[BoxData[
 RowBox[{"ratio1", "=", 
  RowBox[{"LogLinearPlot", "[", "\n", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"pdfFunction", "[", 
         RowBox[{"iset", ",", " ", "21", ",", " ", "x", ",", " ", "q0"}], 
         "]"}], "/", 
        RowBox[{"pdfFunction", "[", 
         RowBox[{"1", ",", " ", "21", ",", " ", "x", ",", " ", "q0"}], 
         "]"}]}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"iset", ",", " ", "1", ",", " ", 
         RowBox[{"Length", "[", "ct10", "]"}], ",", " ", "1"}], "}"}]}], 
      "]"}], " ", "//", " ", "\n", "  ", "Evaluate"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", 
      RowBox[{"10.", "^", 
       RowBox[{"-", "4"}]}], ",", " ", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.602358157141201*^9, 3.602358162846637*^9}, {
   3.602358231876904*^9, 3.6023582354089823`*^9}, {3.632619405312439*^9, 
   3.632619429373307*^9}, 3.6328533249626703`*^9, 3.633281610634087*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Using pdfGetXlist and pdfGetQlist", "Section",
 CellChangeTimes->{{3.561906271058917*^9, 3.5619063278772993`*^9}, {
  3.561998930497334*^9, 3.561998934953187*^9}, {3.594827888124209*^9, 
  3.594827889933007*^9}, {3.594833733893792*^9, 3.594833752585559*^9}, {
  3.602359217554019*^9, 3.6023592200137253`*^9}}],

Cell[CellGroupData[{

Cell["The x and Q grids can be directly read from the stored PDFs.", \
"Subsubsection",
 CellChangeTimes->{{3.593911607633563*^9, 3.59391164161045*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"iset", "=", "1"}], ";"}]], "Input",
 CellChangeTimes->{{3.56199865695103*^9, 3.561998658515305*^9}, {
  3.5939115738987923`*^9, 3.5939115740208*^9}}],

Cell[BoxData[
 RowBox[{"pdfGetQlist", "[", "iset", "]"}]], "Input",
 CellChangeTimes->{{3.561906534993862*^9, 3.561906546131092*^9}, 
   3.561998608950863*^9, 3.561998675597408*^9, {3.588423944994125*^9, 
   3.5884239474934483`*^9}, 3.594472223643585*^9, 3.59482863934096*^9, {
   3.601870269465657*^9, 3.601870273527257*^9}, 3.6326208141361523`*^9}],

Cell[BoxData[
 RowBox[{"pdfGetXlist", "[", "iset", "]"}]], "Input",
 CellChangeTimes->{{3.561906534993862*^9, 3.561906546131092*^9}, {
   3.561998608950863*^9, 3.561998615011114*^9}, 3.561998676173668*^9, {
   3.588423974360979*^9, 3.588423976495566*^9}, 3.594472224595209*^9, 
   3.594828642834461*^9, {3.6018703289621363`*^9, 3.601870331014456*^9}, {
   3.632620817754201*^9, 3.632620818053658*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The pdfXmin function gives the minimum value of x for the set. pdfFunction \
can only reliably interpolate down to this value.\
\>", "Subsubsection",
 CellChangeTimes->{{3.5635733849743423`*^9, 3.563573405141645*^9}, {
  3.563573441725958*^9, 3.563573503161785*^9}, {3.563573544991084*^9, 
  3.563573641597221*^9}, {3.601870456470303*^9, 3.601870457424295*^9}, {
  3.601917437951779*^9, 3.601917450870646*^9}, {3.645209521106621*^9, 
  3.645209530123777*^9}}],

Cell[BoxData[
 RowBox[{"pdfXmin", "[", "iset", "]"}]], "Input",
 CellChangeTimes->{{3.561998637945766*^9, 3.56199864043979*^9}, 
   3.561998677320132*^9, {3.601870343921389*^9, 3.6018703453737183`*^9}, 
   3.6205033373411903`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pdfGetXlist", "[", "iset", "]"}], " ", "//", "Min"}]], "Input",
 CellChangeTimes->{{3.561998623683853*^9, 3.561998624579284*^9}, 
   3.561998676874471*^9, 3.594472225547801*^9, {3.601870352806514*^9, 
   3.601870353752598*^9}, {3.632620831411201*^9, 3.6326208317723713`*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Additional user functions", "Section",
 CellChangeTimes->{{3.601918006089419*^9, 3.601918016162231*^9}, {
  3.6019182022571707`*^9, 3.601918216574252*^9}, {3.602358664857993*^9, 
  3.602358669629999*^9}}],

Cell[CellGroupData[{

Cell["pdfGetInfo function", "Subsection",
 CellChangeTimes->{{3.601918035984503*^9, 3.601918145703794*^9}, {
   3.602358695520577*^9, 3.6023587015403137`*^9}, {3.62050664083374*^9, 
   3.620506648645615*^9}, 3.62172038214822*^9}],

Cell[CellGroupData[{

Cell["\<\
 can be used to show what content from the info file has been read into memory\
\>", "Subsubsection",
 CellChangeTimes->{{3.602358707060734*^9, 3.602358712862619*^9}}],

Cell[BoxData[
 RowBox[{"?", "pdfGetInfo"}]], "Input",
 CellChangeTimes->{{3.60191815156523*^9, 3.601918162320356*^9}, 
   3.621708708648693*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pdfGetInfo", "[", "1", "]"}], "//", "TableForm"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.601918168007799*^9, 3.601918172695607*^9}, {
   3.6217087137232637`*^9, 3.621708730462061*^9}, {3.6217177286944427`*^9, 
   3.6217177337224703`*^9}, 3.6217177950033207`*^9, 3.6217203711051826`*^9, {
   3.6326208959691963`*^9, 3.632620897923799*^9}, {3.645209579629223*^9, 
   3.645209583586069*^9}}],

Cell[BoxData[
 RowBox[{"pdfGetInfo", "[", 
  RowBox[{"1", ",", "\"\<Flavors\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.621720387682455*^9, 3.621720403490528*^9}, {
  3.6326209001811934`*^9, 3.632620900248394*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AlphaS functions", "Subsection",
 CellChangeTimes->{{3.602358632293375*^9, 3.602358655911338*^9}, {
   3.620506654979594*^9, 3.6205066552816267`*^9}, 3.621722089024735*^9}],

Cell[BoxData[
 RowBox[{"alpha", "=", 
  RowBox[{"pdfGetInfo", "[", 
   RowBox[{"1", ",", "\"\<AlphaS_Vals\>\""}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6019182747583838`*^9, 3.601918280340622*^9}, {
   3.601919096290967*^9, 3.601919107412537*^9}, 3.62171447452177*^9, {
   3.621715096207426*^9, 3.6217151176182137`*^9}, 3.621721579880837*^9, {
   3.632621243771509*^9, 3.632621261051653*^9}}],

Cell[BoxData[
 RowBox[{"?", "pdfAlphaS"}]], "Input",
 CellChangeTimes->{{3.6019183724803534`*^9, 3.601918420228663*^9}, {
  3.601918465753409*^9, 3.601918489186042*^9}, {3.601918645863208*^9, 
  3.601918651847166*^9}, {3.601918872831209*^9, 3.6019189131219273`*^9}, {
  3.601918998917564*^9, 3.601919001211917*^9}, {3.6019190926699038`*^9, 
  3.601919104614683*^9}, {3.6019195856361237`*^9, 3.6019195857472277`*^9}, {
  3.601919745769463*^9, 3.6019197703564034`*^9}, {3.601919835137292*^9, 
  3.6019198513912067`*^9}, {3.621715576568213*^9, 3.621715577126359*^9}, {
  3.621718465460102*^9, 3.621718466747938*^9}, {3.6375803026059847`*^9, 
  3.6375803029140244`*^9}}],

Cell[BoxData[
 RowBox[{"qlist", "=", 
  RowBox[{"pdfGetQlist", "[", "1", "]"}], 
  RowBox[{"(*", 
   RowBox[{"retrieve", " ", "qlist", " ", "from", " ", 
    RowBox[{"the", " ", ".", "dat"}], " ", "file"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.6019288771260242`*^9, 3.601928890086855*^9}, {
   3.601929251864406*^9, 3.601929273569501*^9}, {3.621715081303915*^9, 
   3.621715090648596*^9}, 3.621715517888378*^9, 3.6217157698717537`*^9, {
   3.6217215197740192`*^9, 3.6217215217850103`*^9}, 3.621721583517569*^9, {
   3.6326212299555387`*^9, 3.632621230455737*^9}}],

Cell[BoxData[
 RowBox[{"pdfAlphaS", "[", 
  RowBox[{"1", ",", 
   RowBox[{
    RowBox[{"Flatten", "[", "qlist", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.6217178963240747`*^9, {3.621718030106266*^9, 3.621718030546052*^9}, {
   3.637580332717956*^9, 3.637580333644465*^9}, {3.6622342819648123`*^9, 
   3.662234311670918*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "For", " ", "the", " ", "Q", " ", "values", " ", "provided", " ", "in", 
     " ", 
     RowBox[{"the", " ", ".", "dat"}], " ", "file"}], ",", " ", 
    RowBox[{
    "this", " ", "checks", " ", "that", " ", "the", " ", "the", " ", "AlphaS",
      " ", "values", " ", "at", " ", "those", " ", "values", " ", "match", 
     " ", "those", " ", "in", " ", 
     RowBox[{"the", " ", ".", "info"}], " ", "file"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"If", " ", "they", " ", 
     RowBox[{"don", "'"}], "t", " ", "match"}], ",", " ", 
    RowBox[{
    "the", " ", "alpha", " ", "value", " ", "in", " ", "the", " ", "info", 
     " ", "file", " ", "is", " ", 
     RowBox[{"dropped", ".", " ", "This"}], " ", "is", " ", "done", " ", 
     "for", " ", "demonstration", " ", "purposes"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", 
    RowBox[{"i", "\[LessEqual]", 
     RowBox[{"Length", "[", 
      RowBox[{"Flatten", "[", "qlist", "]"}], "]"}]}], ",", 
    RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{"If", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"pdfAlphaS", "[", 
        RowBox[{"1", ",", 
         RowBox[{
          RowBox[{"Flatten", "[", "qlist", "]"}], "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "]"}], "\[NotEqual]", 
       RowBox[{"alpha", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], ",", 
      RowBox[{"alpha", "=", 
       RowBox[{"Drop", "[", 
        RowBox[{"alpha", ",", 
         RowBox[{"{", "i", "}"}]}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}],
    "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.601928664325186*^9, 3.601928856728806*^9}, {
   3.601928896380026*^9, 3.6019289029783278`*^9}, {3.601929011186116*^9, 
   3.601929014187264*^9}, {3.601929070687996*^9, 3.6019290880524673`*^9}, {
   3.601929193589982*^9, 3.601929195142768*^9}, {3.60192928956647*^9, 
   3.601929482007969*^9}, 3.62171479315457*^9, {3.621715463012608*^9, 
   3.621715484679987*^9}, {3.62171552628334*^9, 3.621715526355884*^9}, {
   3.621721013298223*^9, 3.6217210140862722`*^9}, {3.637580342700498*^9, 
   3.637580343168545*^9}, {3.6622343488040247`*^9, 3.662234365818103*^9}}],

Cell[BoxData[
 RowBox[{"tab1", "=", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Flatten", "[", "qlist", "]"}], ",", "alpha"}], "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.601929735426755*^9, 3.601929738865181*^9}, {
   3.62171513070721*^9, 3.62171513158113*^9}, 3.662233978892233*^9, 
   3.662234369993388*^9}],

Cell[BoxData[
 RowBox[{"p1", "=", 
  RowBox[{"ListLogLogPlot", "[", 
   RowBox[{"tab1", ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Q\>\"", ",", "\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(s\)]\)\>\""}],
       "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"PointSize", "[", ".02", "]"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.60192053390876*^9, 3.601920588521042*^9}, {
   3.601920640669017*^9, 3.601920724639998*^9}, {3.6019207698583927`*^9, 
   3.6019208039129257`*^9}, {3.601921161980034*^9, 3.601921176983762*^9}, {
   3.601921285230089*^9, 3.6019212962012463`*^9}, {3.601921340254444*^9, 
   3.601921350241885*^9}, {3.601924382209177*^9, 3.601924408317835*^9}, {
   3.6019244526032133`*^9, 3.601924475772203*^9}, {3.601924549075123*^9, 
   3.601924557285575*^9}, {3.6019246085161667`*^9, 3.601924616878716*^9}, 
   3.601924849919653*^9, {3.601925349932188*^9, 3.6019253673973923`*^9}, {
   3.601929732713702*^9, 3.601929741610197*^9}, 3.632853315251416*^9, 
   3.633281624009715*^9}],

Cell[CellGroupData[{

Cell["pdfAlphaS function plotting", "Subsubsection",
 CellChangeTimes->{{3.601921046674285*^9, 3.601921061735352*^9}, {
  3.601928446293859*^9, 3.601928488574038*^9}, {3.645209658347927*^9, 
  3.645209661023622*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "produces", " ", "a", " ", "data", " ", "set", " ", "of", " ",
     "interpolated", " ", "AlphaS", " ", "values"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"tab2", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e0", "=", 
     RowBox[{"Log", "[", 
      RowBox[{"10", ",", "1.3"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"ee", "=", "e0"}], ",", 
     RowBox[{"ee", "\[LessEqual]", "5"}], ",", 
     RowBox[{"ee", "+=", 
      RowBox[{"1", "/", "5."}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"i", "=", 
       RowBox[{"10.", "^", "ee"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"tab2", "=", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"tab2", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"pdfAlphaS", "[", 
            RowBox[{"1", ",", "i"}], "]"}]}], "}"}]}], "]"}]}]}]}], 
    "\[IndentingNewLine]", "]"}], " "}]}]], "Input",
 CellChangeTimes->{
  3.6019240839834833`*^9, {3.6019241189622793`*^9, 3.601924123027618*^9}, 
   3.6019241796765633`*^9, {3.601925311843678*^9, 3.6019253147840023`*^9}, {
   3.601928502497959*^9, 3.601928571401558*^9}, {3.601929586986339*^9, 
   3.601929595053019*^9}, 3.6217150041247263`*^9, {3.62172161931444*^9, 
   3.621721619726701*^9}, {3.6217216838564777`*^9, 3.621721683954344*^9}, {
   3.63758038616535*^9, 3.637580386648851*^9}, {3.64709769908805*^9, 
   3.647097699902244*^9}, {3.647097801064588*^9, 3.647097844184198*^9}, {
   3.64709787925498*^9, 3.6470979063461103`*^9}, 3.647097937086226*^9, {
   3.647098022458296*^9, 3.647098134711967*^9}, {3.64709824047235*^9, 
   3.647098240490519*^9}}],

Cell[BoxData[
 RowBox[{"p2", "=", 
  RowBox[{"ListLogLogPlot", "[", 
   RowBox[{"tab2", ",", 
    RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Q\>\"", ",", "\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(s\)]\)\>\""}],
       "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", "Red", "}"}]}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.601924105733211*^9, 3.601924107030449*^9}, {
   3.601924216709592*^9, 3.601924261359413*^9}, {3.601924304129744*^9, 
   3.601924312903358*^9}, {3.601924369210005*^9, 3.601924371573069*^9}, 
   3.601924568703445*^9, {3.601924623001045*^9, 3.6019246287461033`*^9}, 
   3.6019248593323708`*^9, {3.601924965373383*^9, 3.601924981384386*^9}, {
   3.601925016455043*^9, 3.601925019138701*^9}, {3.601925185710369*^9, 
   3.6019251970442657`*^9}, {3.6019252276363697`*^9, 3.601925256223526*^9}, {
   3.6019256621512623`*^9, 3.601925720492872*^9}, {3.601925765482503*^9, 
   3.601925845910919*^9}, {3.601925946443822*^9, 3.6019259554628897`*^9}, {
   3.601925991294363*^9, 3.601926055204483*^9}, {3.601926342186095*^9, 
   3.601926434814272*^9}, {3.60192649306406*^9, 3.60192649402621*^9}, {
   3.601928426231792*^9, 3.601928427358802*^9}, 3.601929595994795*^9, {
   3.647098152476384*^9, 3.647098161824615*^9}}],

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tab1", ",", "tab2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Q\>\"", ",", "\"\<\!\(\*SubscriptBox[\(\[Alpha]\), \(s\)]\)\>\""}], 
     "}"}]}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Given\>\"", ",", "\"\<Interpolated\>\""}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", ".02", "]"}], ",", 
      RowBox[{"PointSize", "[", ".005", "]"}]}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "True"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6019244942240877`*^9, 3.60192449609198*^9}, {
   3.6019247685380583`*^9, 3.6019248017117987`*^9}, {3.601924867708346*^9, 
   3.601924896487679*^9}, {3.60192493994077*^9, 3.601924941769663*^9}, {
   3.60192538444105*^9, 3.601925410269437*^9}, {3.601929516758977*^9, 
   3.601929551855311*^9}, {3.6019296209989758`*^9, 3.601929687108922*^9}, 
   3.601929755024675*^9, {3.6019297952008667`*^9, 3.601929914862821*^9}, {
   3.601930010183421*^9, 3.601930175224329*^9}, 3.632853291516341*^9, 
   3.633281632305789*^9, {3.6452096887034283`*^9, 3.645209702963128*^9}, {
   3.647098201691264*^9, 3.647098217508679*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
The noticeable kink in the 1/AlphaS plot when the b quark turns on is \
apparent in the plots below\
\>", "Subsubsection",
 CellChangeTimes->{{3.601930341453888*^9, 3.60193044719707*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tab", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1.3"}], ",", 
    RowBox[{"i", "\[LessEqual]", "50"}], ",", 
    RowBox[{"i", "+=", ".01"}], ",", "\[IndentingNewLine]", 
    RowBox[{"tab", "=", 
     RowBox[{"AppendTo", "[", 
      RowBox[{"tab", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"1", "/", 
          RowBox[{"pdfAlphaS", "[", 
           RowBox[{"1", ",", "i"}], "]"}]}]}], "}"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], " "}]}], "Input",
 CellChangeTimes->{{3.6019210641202383`*^9, 3.6019211430867434`*^9}, {
   3.601921181558858*^9, 3.6019211824377832`*^9}, {3.6019212169875507`*^9, 
   3.601921218176858*^9}, {3.601921265327914*^9, 3.601921270125915*^9}, {
   3.601921355930806*^9, 3.6019213618589497`*^9}, 3.6019215246363087`*^9, {
   3.601923726617557*^9, 3.601923873689949*^9}, {3.601923992378912*^9, 
   3.6019240224058847`*^9}, {3.601926524915537*^9, 3.6019265298628407`*^9}, {
   3.621721689675907*^9, 3.6217216897534447`*^9}, {3.637580432306487*^9, 
   3.637580433205267*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"ListLogLinearPlot", "[", "tab", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.601921495406719*^9, 3.601921498332303*^9}, {
   3.601923883707541*^9, 3.601923942810235*^9}, {3.601923998717753*^9, 
   3.60192400792559*^9}, {3.601926547303494*^9, 3.601926548272312*^9}, 
   3.632853302129569*^9, {3.6375804599896593`*^9, 3.6375804845987463`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", 
   RowBox[{"Fit", "[", 
    RowBox[{
     RowBox[{"Take", "[", 
      RowBox[{"tab", ",", 
       RowBox[{"-", "500"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"Log", "[", "x", "]"}]}], "}"}], ",", "x"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"f2", "=", 
   RowBox[{"Fit", "[", 
    RowBox[{
     RowBox[{"Take", "[", 
      RowBox[{"tab", ",", "300"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"Log", "[", "x", "]"}]}], "}"}], ",", "x"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.601927132972229*^9, 3.601927145699913*^9}, {
   3.6019272055935593`*^9, 3.601927244046974*^9}, {3.601927469137541*^9, 
   3.601927495369693*^9}, {3.601927826458816*^9, 3.6019278689466267`*^9}, {
   3.601927918370863*^9, 3.6019280097934723`*^9}, 3.601928053100957*^9, {
   3.60192818614272*^9, 3.6019282810940437`*^9}, {3.601928323751258*^9, 
   3.6019283559462852`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"p4", "=", 
   RowBox[{"LogLinearPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f1", ",", "f2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "50"}], "}"}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<b on\>\"", ",", "\"\<b off\>\""}], "}"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6019274390593452`*^9, 3.6019274394213963`*^9}, {
   3.601927490528754*^9, 3.601927513815596*^9}, {3.601927837274077*^9, 
   3.60192786251637*^9}, {3.601928019712513*^9, 3.6019280993582277`*^9}, {
   3.60192814110981*^9, 3.601928249313924*^9}, {3.601928335313871*^9, 
   3.601928353133566*^9}, 3.601928408022291*^9, 3.632853308259066*^9, {
   3.637580466733609*^9, 3.6375804708369713`*^9}, {3.645376630214471*^9, 
   3.64537664563736*^9}}],

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"p3", ",", "p4"}], "]"}]], "Input",
 CellChangeTimes->{{3.6019266918669252`*^9, 3.6019266969648314`*^9}, {
  3.601927475080224*^9, 3.60192747661173*^9}, {3.601928371369878*^9, 
  3.6019283725159063`*^9}}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example: Change to new PDF family", "Section",
 CellChangeTimes->{{3.601930584081408*^9, 3.601930590127973*^9}, {
  3.602358403541939*^9, 3.602358437054604*^9}, {3.645376674836482*^9, 
  3.645376676109646*^9}}],

Cell[CellGroupData[{

Cell["\<\
This demonstrates how to switch from one PDF family to another\
\>", "Subsection",
 CellChangeTimes->{{3.6023583942571163`*^9, 3.602358397425118*^9}, {
  3.602358450471031*^9, 3.6023585212070017`*^9}, {3.6327691505422583`*^9, 
  3.632769152602188*^9}}],

Cell[BoxData[
 RowBox[{"pdfReset", "[", "]"}]], "Input",
 CellChangeTimes->{{3.601930908353921*^9, 3.601930930478073*^9}, {
  3.620506577433976*^9, 3.620506584741835*^9}, {3.632620839846436*^9, 
  3.632620840684805*^9}}],

Cell[BoxData[
 RowBox[{"MSTW", "=", 
  RowBox[{"pdfFamilyParseLHA", "[", "dirMSTW", "]"}]}]], "Input",
 CellChangeTimes->{{3.601931250766621*^9, 3.601931313562849*^9}, {
   3.620506597803405*^9, 3.6205066105110693`*^9}, 3.632753481033999*^9, 
   3.632754573779035*^9, 3.633977984435542*^9, 3.6453766878791933`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pdfFunction", "[", 
    RowBox[{"#", ",", " ", "0", ",", " ", "0.1", ",", " ", "10."}], "]"}], 
   " ", "&"}], " ", "/@", " ", "MSTW"}]], "Input",
 CellChangeTimes->{{3.601931363243339*^9, 3.601931400690681*^9}, {
   3.601931475413424*^9, 3.601931477684278*^9}, {3.6205066175962667`*^9, 
   3.620506619110364*^9}, {3.632620860293597*^9, 3.632620860578307*^9}, 
   3.6327534847554827`*^9, 3.632754579613645*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"q0", " ", "=", " ", "10."}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"length", "=", 
   RowBox[{"MSTW", "//", "Length"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.601931363243339*^9, 3.601931419889761*^9}, 
   3.6327534877207127`*^9, 3.632754585588565*^9, {3.632769059839923*^9, 
   3.632769062638088*^9}, {3.632769098748308*^9, 3.632769109134448*^9}}],

Cell[BoxData[
 RowBox[{"ratio2", "=", 
  RowBox[{"LogLinearPlot", "[", "\n", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"pdfFunction", "[", 
         RowBox[{"iset", ",", " ", "0", ",", " ", "x", ",", " ", "q0"}], 
         "]"}], "/", 
        RowBox[{"pdfFunction", "[", 
         RowBox[{"1", ",", " ", "0", ",", " ", "x", ",", " ", "q0"}], "]"}]}],
        ",", " ", 
       RowBox[{"{", 
        RowBox[{"iset", ",", " ", "1", ",", "length", ",", " ", "1"}], 
        "}"}]}], "]"}], " ", "//", " ", "\n", "  ", "Evaluate"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", " ", 
      RowBox[{"10.", "^", 
       RowBox[{"-", "4"}]}], ",", " ", "1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.601931363243339*^9, 3.6019314281400337`*^9}, {
   3.601931481558722*^9, 3.60193148856975*^9}, {3.6023582490219507`*^9, 
   3.602358252096642*^9}, {3.620506750536003*^9, 3.620506755143794*^9}, 
   3.62050694683461*^9, {3.632620864130746*^9, 3.63262086943222*^9}, 
   3.632753491958252*^9, 3.632754588594019*^9, {3.63276911341822*^9, 
   3.632769114227364*^9}, 3.632853279798307*^9, 3.633281642123646*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pdfGetInfo", "[", "1", "]"}], "//", "TableForm"}]], "Input",
 CellChangeTimes->{{3.6339792451843967`*^9, 3.633979260464012*^9}, {
  3.645376714895808*^9, 3.645376719080847*^9}}],

Cell[BoxData[
 RowBox[{"xlist", "=", 
  RowBox[{"pdfGetXlist", "[", "1", "]"}]}]], "Input",
 CellChangeTimes->{{3.6339787004296713`*^9, 3.63397870795961*^9}, {
  3.633979369406075*^9, 3.633979370524858*^9}}],

Cell[CellGroupData[{

Cell["\<\
Note for MSTW grids, the .dat file is divided into multiple sections based on \
Q value, thus extra inputs maybe required.\
\>", "Subsubsection",
 CellChangeTimes->{{3.645376929188958*^9, 3.6453770558196774`*^9}, {
  3.645377455986146*^9, 3.6453774697053747`*^9}, {3.645377521675681*^9, 
  3.6453775279887114`*^9}}],

Cell[BoxData[
 RowBox[{"?", "pdfNumQpartition"}]], "Input",
 CellChangeTimes->{{3.645377539420906*^9, 3.6453775445276423`*^9}}],

Cell[BoxData[
 RowBox[{"pdfNumQpartition", "[", "1", "]"}]], "Input",
 CellChangeTimes->{{3.645377059245719*^9, 3.645377063817877*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"qlist", "=", 
  RowBox[{"pdfGetQlist", "[", 
   RowBox[{"1", ",", "3"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.633978710745715*^9, 3.633978766992511*^9}, {
  3.633979373973353*^9, 3.6339793751816053`*^9}, {3.6453768972213907`*^9, 
  3.645376920886245*^9}}],

Cell[BoxData[
 RowBox[{"LHAplot", "[", 
  RowBox[{"1", ",", "0", ",", "1.3"}], "]"}]], "Input",
 CellChangeTimes->{{3.632755109709848*^9, 3.632755135743539*^9}, {
  3.632755171998309*^9, 3.6327551753429203`*^9}, {3.632755319296227*^9, 
  3.632755341297484*^9}, {3.632769301482813*^9, 3.632769307110252*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ipart", "=", "0"}], ";"}], " ", 
  RowBox[{"(*", " ", "GLUON", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q0", "=", "1.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bandplot", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"LHAplot", "[", 
      RowBox[{"i", ",", "ipart", ",", "q0"}], "]"}], " ", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"MSTW", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "length"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{"bandplot", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.558915350696766*^9, 3.558915350705133*^9}, 
   3.558915720881357*^9, {3.558915857272008*^9, 3.558915867038445*^9}, 
   3.558916104030587*^9, {3.5589161434468737`*^9, 3.55891615822787*^9}, {
   3.558916208875682*^9, 3.558916210054183*^9}, {3.559664081700219*^9, 
   3.559664094930492*^9}, {3.559664126644627*^9, 3.559664126876523*^9}, {
   3.561997397282724*^9, 3.561997409210947*^9}, {3.561998734994577*^9, 
   3.561998909088851*^9}, {3.5635741336020193`*^9, 3.563574143155532*^9}, {
   3.563577029059705*^9, 3.563577045126902*^9}, {3.563577087016773*^9, 
   3.563577087215076*^9}, {3.5635803998866873`*^9, 3.5635804124556293`*^9}, {
   3.578095897248694*^9, 3.578095964572856*^9}, {3.588420322747913*^9, 
   3.588420413286306*^9}, {3.5932669779065857`*^9, 3.5932670086677523`*^9}, {
   3.593906838566944*^9, 3.593906889944812*^9}, {3.59390769218447*^9, 
   3.593907755139399*^9}, {3.593907799159979*^9, 3.5939078396750307`*^9}, {
   3.5939113504686604`*^9, 3.5939113614805098`*^9}, {3.594827286760224*^9, 
   3.594827299483223*^9}, {3.6018700600628147`*^9, 3.6018700607746887`*^9}, {
   3.601870171110506*^9, 3.601870206955906*^9}, 3.620503299597548*^9, {
   3.620504863500126*^9, 3.620504866366688*^9}, {3.63275489282478*^9, 
   3.6327549040924397`*^9}, 3.632755274727247*^9, 3.632853269044866*^9, 
   3.63328164893239*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Working with multiple families at once.", "Subsection",
 CellChangeTimes->{{3.645377622397875*^9, 3.6453776414539337`*^9}, {
  3.6453776872944736`*^9, 3.645377688783718*^9}}],

Cell[BoxData[
 RowBox[{"pdfReset", "[", "]"}]], "Input",
 CellChangeTimes->{{3.601930908353921*^9, 3.601930930478073*^9}, {
  3.620506577433976*^9, 3.620506584741835*^9}, {3.632620839846436*^9, 
  3.632620840684805*^9}}],

Cell[BoxData[{
 RowBox[{"MSTW", "=", 
  RowBox[{"pdfFamilyParseLHA", "[", "dirMSTW", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ct10", "=", 
  RowBox[{"pdfFamilyParseLHA", "[", "dirCT10", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"nnpdf", "=", 
  RowBox[{"pdfFamilyParseLHA", "[", "dirNNPDF", "]"}]}]}], "Input",
 CellChangeTimes->{{3.632756346509721*^9, 3.632756357762252*^9}, {
  3.6327577866106653`*^9, 3.6327578013051977`*^9}, {3.632762527280036*^9, 
  3.6327625290441427`*^9}, {3.6327699383771887`*^9, 3.632769938758665*^9}, {
  3.645377834198016*^9, 3.645377848164154*^9}}],

Cell[BoxData[
 RowBox[{"total", "=", 
  RowBox[{"pdfSetList", "//", "Length"}]}]], "Input",
 CellChangeTimes->{{3.645378079183731*^9, 3.645378105516176*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Join", "[", 
   RowBox[{"MSTW", ",", "ct10", ",", "nnpdf"}], "]"}], "//", 
  "Length"}]], "Input",
 CellChangeTimes->{{3.645378121104084*^9, 3.6453781974344473`*^9}}],

Cell[CellGroupData[{

Cell["Check sum rule:", "Subsubsection",
 CellChangeTimes->{{3.55838969078966*^9, 3.558389705520049*^9}, {
   3.5599433920286007`*^9, 3.559943405337268*^9}, {3.578094482321333*^9, 
   3.5780944985775747`*^9}, 3.6017517105076313`*^9}],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"NIntegrate", "::", "izero"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q0", "=", "2.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"iset0", "=", "1"}], ";"}], 
  RowBox[{"(*", "MSTW", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.558388176662824*^9, 3.558388237585742*^9}, {
   3.558388316374671*^9, 3.558388339130072*^9}, {3.558877222312537*^9, 
   3.558877222411696*^9}, 3.558914951117453*^9, 3.558916269097796*^9, {
   3.559663948356461*^9, 3.559664003410111*^9}, 3.559943258309353*^9, {
   3.593266820949542*^9, 3.5932668317122517`*^9}, 3.593904688611562*^9, {
   3.5948366962967*^9, 3.594836697605308*^9}, {3.594836836164318*^9, 
   3.594836854014057*^9}, 3.594836918672712*^9, 3.601752014609395*^9, {
   3.645378222586968*^9, 3.645378227806066*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tab", "=", " ", 
   RowBox[{"Table", "[", " ", 
    RowBox[{
     RowBox[{"NIntegrate", "[", "  ", 
      RowBox[{
       RowBox[{"x", "*", 
        RowBox[{"pdf", "[", 
         RowBox[{"iset0", ",", "ipart", ",", "x", ",", "q0"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ipart", ",", 
       RowBox[{"-", "5"}], ",", "5", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plus", " ", "@@", " ", "tab"}]}], "Input",
 CellChangeTimes->{{3.594837134140593*^9, 3.594837135493274*^9}, {
   3.601751751037738*^9, 3.601751752971987*^9}, 3.601752278398031*^9, {
   3.6326207495695143`*^9, 3.632620750524805*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"flavorlist", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.601752882211306*^9, 3.6017528887835417`*^9}, {
   3.6017534889266443`*^9, 3.601753489856092*^9}, 3.601753646443508*^9, {
   3.6017538512802343`*^9, 3.601753858127514*^9}}],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", 
    RowBox[{"-", "5"}]}], ",", 
   RowBox[{"i", "\[LessEqual]", "5"}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{
    RowBox[{"AppendTo", "[", 
     RowBox[{"flavorlist", ",", 
      RowBox[{"pdfFlavor", "[", "i", "]"}]}], "]"}], ";"}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.601753610123262*^9, 3.601753643329199*^9}, {
   3.601753677793241*^9, 3.601753679638341*^9}, {3.601753747801209*^9, 
   3.601753756136877*^9}, {3.60175378894305*^9, 3.60175384772458*^9}, 
   3.620503230549233*^9}],

Cell[BoxData["flavorlist"], "Input",
 CellChangeTimes->{{3.601752562361206*^9, 3.60175257031732*^9}, {
  3.601752741521762*^9, 3.60175278027628*^9}, {3.6017528539062347`*^9, 
  3.6017528760288897`*^9}, {3.601752919973709*^9, 3.601752920071772*^9}, {
  3.6017530092084923`*^9, 3.6017530353146353`*^9}, {3.6017534746600924`*^9, 
  3.601753482951816*^9}, {3.601753653966588*^9, 3.601753657192586*^9}, {
  3.6017538679503736`*^9, 3.601753869045025*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "flavorlist", ",", 
     RowBox[{"Round", "[", 
      RowBox[{"100", " ", "tab"}], "]"}]}], "}"}], " ", "//", "Transpose"}], 
  " ", "//", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], "&"}]}]], "Input",
 CellChangeTimes->{{3.594837426000315*^9, 3.594837512743508*^9}, {
   3.594837550221739*^9, 3.594837550940566*^9}, {3.59483763237888*^9, 
   3.594837708593923*^9}, {3.594837752075708*^9, 3.594837786565183*^9}, {
   3.601751798344823*^9, 3.601751811639182*^9}, {3.601753056194503*^9, 
   3.601753063082972*^9}, {3.6017531033184557`*^9, 3.601753103783552*^9}, 
   3.601753452524457*^9, {3.601753873217416*^9, 3.60175387477721*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check sum rule:", "Subsubsection",
 CellChangeTimes->{{3.55838969078966*^9, 3.558389705520049*^9}, {
   3.5599433920286007`*^9, 3.559943405337268*^9}, {3.578094482321333*^9, 
   3.5780944985775747`*^9}, 3.6017517105076313`*^9}],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"NIntegrate", "::", "izero"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q0", "=", "2.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"iset0", "=", 
    RowBox[{"total", "-", 
     RowBox[{"(", 
      RowBox[{"Length", "[", "nnpdf", "]"}], ")"}], "+", "1"}]}], ";"}], 
  RowBox[{"(*", "nnpdf", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.558388176662824*^9, 3.558388237585742*^9}, {
   3.558388316374671*^9, 3.558388339130072*^9}, {3.558877222312537*^9, 
   3.558877222411696*^9}, 3.558914951117453*^9, 3.558916269097796*^9, {
   3.559663948356461*^9, 3.559664003410111*^9}, 3.559943258309353*^9, {
   3.593266820949542*^9, 3.5932668317122517`*^9}, 3.593904688611562*^9, {
   3.5948366962967*^9, 3.594836697605308*^9}, {3.594836836164318*^9, 
   3.594836854014057*^9}, 3.594836918672712*^9, 3.601752014609395*^9, {
   3.6328532401783123`*^9, 3.632853240543824*^9}, {3.6453782486356277`*^9, 
   3.645378258940583*^9}, {3.645378376707892*^9, 3.645378395431703*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tab", "=", " ", 
   RowBox[{"Table", "[", " ", 
    RowBox[{
     RowBox[{"NIntegrate", "[", "  ", 
      RowBox[{
       RowBox[{"x", "*", 
        RowBox[{"pdf", "[", 
         RowBox[{"iset0", ",", "ipart", ",", "x", ",", "q0"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ipart", ",", 
       RowBox[{"-", "5"}], ",", "5", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plus", " ", "@@", " ", "tab"}]}], "Input",
 CellChangeTimes->{{3.594837134140593*^9, 3.594837135493274*^9}, {
   3.601751751037738*^9, 3.601751752971987*^9}, 3.601752278398031*^9, {
   3.6326207495695143`*^9, 3.632620750524805*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"flavorlist", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.601752882211306*^9, 3.6017528887835417`*^9}, {
   3.6017534889266443`*^9, 3.601753489856092*^9}, 3.601753646443508*^9, {
   3.6017538512802343`*^9, 3.601753858127514*^9}}],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", 
    RowBox[{"-", "5"}]}], ",", 
   RowBox[{"i", "\[LessEqual]", "5"}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{
    RowBox[{"AppendTo", "[", 
     RowBox[{"flavorlist", ",", 
      RowBox[{"pdfFlavor", "[", "i", "]"}]}], "]"}], ";"}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.601753610123262*^9, 3.601753643329199*^9}, {
   3.601753677793241*^9, 3.601753679638341*^9}, {3.601753747801209*^9, 
   3.601753756136877*^9}, {3.60175378894305*^9, 3.60175384772458*^9}, 
   3.620503230549233*^9}],

Cell[BoxData["flavorlist"], "Input",
 CellChangeTimes->{{3.601752562361206*^9, 3.60175257031732*^9}, {
  3.601752741521762*^9, 3.60175278027628*^9}, {3.6017528539062347`*^9, 
  3.6017528760288897`*^9}, {3.601752919973709*^9, 3.601752920071772*^9}, {
  3.6017530092084923`*^9, 3.6017530353146353`*^9}, {3.6017534746600924`*^9, 
  3.601753482951816*^9}, {3.601753653966588*^9, 3.601753657192586*^9}, {
  3.6017538679503736`*^9, 3.601753869045025*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "flavorlist", ",", 
     RowBox[{"Round", "[", 
      RowBox[{"100", " ", "tab"}], "]"}]}], "}"}], " ", "//", "Transpose"}], 
  " ", "//", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], "&"}]}]], "Input",
 CellChangeTimes->{{3.594837426000315*^9, 3.594837512743508*^9}, {
   3.594837550221739*^9, 3.594837550940566*^9}, {3.59483763237888*^9, 
   3.594837708593923*^9}, {3.594837752075708*^9, 3.594837786565183*^9}, {
   3.601751798344823*^9, 3.601751811639182*^9}, {3.601753056194503*^9, 
   3.601753063082972*^9}, {3.6017531033184557`*^9, 3.601753103783552*^9}, 
   3.601753452524457*^9, {3.601753873217416*^9, 3.60175387477721*^9}, {
   3.647223030418302*^9, 3.64722309222995*^9}, {3.647223162646055*^9, 
   3.6472231760734577`*^9}}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["PDS Files", "Section",
 CellChangeTimes->{{3.64537788441403*^9, 3.645377898390355*^9}}],

Cell[CellGroupData[{

Cell["\<\
Here we demonstrate the ability to handle PDS files in addition to LHA files\
\>", "Subsection",
 CellChangeTimes->{{3.64537793236097*^9, 3.645377976950337*^9}}],

Cell[BoxData[
 RowBox[{"pdfReset", "[", "]"}]], "Input",
 CellChangeTimes->{{3.645377993647606*^9, 3.645377996344379*^9}}],

Cell[BoxData[
 RowBox[{"ct10pds", "=", 
  RowBox[{"pdfFamilyParseCTEQ", "[", "dirCT10pds", "]"}]}]], "Input",
 CellChangeTimes->{{3.645188422453899*^9, 3.6451884492662973`*^9}, 
   3.645193035764413*^9, {3.645378006513529*^9, 3.645378020035447*^9}}],

Cell[BoxData[
 RowBox[{"CTEQ66", "=", 
  RowBox[{"pdfFamilyParseCTEQ", "[", "dirCTEQ66", "]"}]}]], "Input",
 CellChangeTimes->{{3.6451885503153563`*^9, 3.645188576376273*^9}, 
   3.645193035767467*^9, {3.645378023428555*^9, 3.6453780264179363`*^9}}],

Cell[BoxData[
 RowBox[{"pdfFunction", "[", 
  RowBox[{"1", ",", "1", ",", ".1", ",", "10"}], "]"}]], "Input",
 CellChangeTimes->{{3.592251774979146*^9, 3.592251802377573*^9}, 
   3.59225212516621*^9, {3.592252756909343*^9, 3.592252796048566*^9}, {
   3.592252862015884*^9, 3.592252869235325*^9}, {3.592253515389323*^9, 
   3.592253518183917*^9}, {3.59225430903328*^9, 3.59225430984164*^9}, {
   3.592256603284144*^9, 3.592256617995723*^9}, {3.592256839816321*^9, 
   3.592256846091628*^9}, {3.5922591076838417`*^9, 3.5922591105930347`*^9}, {
   3.592261958580059*^9, 3.592261960074806*^9}, {3.5932659957577353`*^9, 
   3.593266006973802*^9}, {3.601751294635931*^9, 3.601751295236204*^9}, {
   3.632614993532839*^9, 3.632614993894493*^9}, 3.6451930357622013`*^9}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "pdf", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pdf", "[", 
   RowBox[{
    RowBox[{"iset_", "?", "IntegerQ"}], ",", 
    RowBox[{"ipart_", "?", "IntegerQ"}], ",", 
    RowBox[{"x_", "?", "NumericQ"}], ",", 
    RowBox[{"q_", "?", "NumericQ"}]}], "]"}], ":=", 
  RowBox[{"pdfFunction", "[", 
   RowBox[{"iset", ",", "ipart", ",", "x", ",", "q"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.559664527889824*^9, 3.55966455919501*^9}, {
   3.5596645934935503`*^9, 3.559664596482181*^9}, {3.5599429030254517`*^9, 
   3.559942905780265*^9}, {3.563216903599263*^9, 3.5632169136662617`*^9}, 
   3.56321722970466*^9, {3.566746500520062*^9, 3.566746541416832*^9}, {
   3.575653846415822*^9, 3.575653847615641*^9}, {3.5795748178496647`*^9, 
   3.579574843368395*^9}, {3.592250755779875*^9, 3.592250757935133*^9}, {
   3.593266590947604*^9, 3.593266593826728*^9}, {3.5932666239856157`*^9, 
   3.593266685556769*^9}, {3.60175158254762*^9, 3.601751583080552*^9}, 
   3.632616971250416*^9, 3.64519303576269*^9}],

Cell[BoxData[{
 RowBox[{"pdf", "[", 
  RowBox[{"1", ",", "1", ",", ".1", ",", "10"}], "]"}], "\n", 
 RowBox[{
  RowBox[{"pdf", "[", 
   RowBox[{"2", ",", "1", ",", "0.1", ",", "10"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"centralvalue", " ", "=", " ", "1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"pdf", "[", 
  RowBox[{"centralvalue", ",", "1", ",", "0.1", ",", "10"}], "]"}]}], "Input",\

 CellChangeTimes->{{3.575654018449548*^9, 3.57565402969004*^9}, 
   3.5932666115108147`*^9, {3.59390475566858*^9, 3.593904761070496*^9}, {
   3.5939088355730762`*^9, 3.593908838926797*^9}, {3.6017516408866653`*^9, 
   3.601751688603477*^9}, 3.6451930357637043`*^9, {3.645208916134046*^9, 
   3.645208930323936*^9}}],

Cell[CellGroupData[{

Cell["Check sum rule:", "Subsubsection",
 CellChangeTimes->{{3.55838969078966*^9, 3.558389705520049*^9}, {
   3.5599433920286007`*^9, 3.559943405337268*^9}, {3.578094482321333*^9, 
   3.5780944985775747`*^9}, 3.6017517105076313`*^9, 3.645193035769907*^9}],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"NIntegrate", "::", "izero"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q0", "=", "2.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"iset0", "=", "1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.558388176662824*^9, 3.558388237585742*^9}, {
   3.558388316374671*^9, 3.558388339130072*^9}, {3.558877222312537*^9, 
   3.558877222411696*^9}, 3.558914951117453*^9, 3.558916269097796*^9, {
   3.559663948356461*^9, 3.559664003410111*^9}, 3.559943258309353*^9, {
   3.593266820949542*^9, 3.5932668317122517`*^9}, 3.593904688611562*^9, {
   3.5948366962967*^9, 3.594836697605308*^9}, {3.594836836164318*^9, 
   3.594836854014057*^9}, 3.594836918672712*^9, 3.601752014609395*^9, {
   3.645188602471499*^9, 3.6451886025211983`*^9}, 3.6451930357701893`*^9, 
   3.645208836812763*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tab", "=", " ", 
   RowBox[{"Table", "[", " ", 
    RowBox[{
     RowBox[{"NIntegrate", "[", " ", 
      RowBox[{
       RowBox[{"x", " ", 
        RowBox[{"pdf", "[", 
         RowBox[{"iset0", ",", "ipart", ",", "x", ",", "q0"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ipart", ",", 
       RowBox[{"-", "5"}], ",", "5", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plus", " ", "@@", " ", "tab"}]}], "Input",
 CellChangeTimes->{{3.594837134140593*^9, 3.594837135493274*^9}, {
   3.601751751037738*^9, 3.601751752971987*^9}, 3.601752278398031*^9, {
   3.6326207495695143`*^9, 3.632620750524805*^9}, 3.635701610608427*^9, 
   3.637579731131372*^9, 3.645193035771167*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"flavorlist", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.601752882211306*^9, 3.6017528887835417`*^9}, {
   3.6017534889266443`*^9, 3.601753489856092*^9}, 3.601753646443508*^9, {
   3.6017538512802343`*^9, 3.601753858127514*^9}, 3.645193035772922*^9}],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", 
    RowBox[{"-", "5"}]}], ",", 
   RowBox[{"i", "\[LessEqual]", "5"}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{
    RowBox[{"AppendTo", "[", 
     RowBox[{"flavorlist", ",", 
      RowBox[{"pdfFlavor", "[", "i", "]"}]}], "]"}], ";"}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.601753610123262*^9, 3.601753643329199*^9}, {
   3.601753677793241*^9, 3.601753679638341*^9}, {3.601753747801209*^9, 
   3.601753756136877*^9}, {3.60175378894305*^9, 3.60175384772458*^9}, 
   3.620503230549233*^9, {3.632853466181031*^9, 3.632853470753668*^9}, 
   3.63757999765338*^9, 3.645193035773881*^9}],

Cell[BoxData["flavorlist"], "Input",
 CellChangeTimes->{{3.601752562361206*^9, 3.60175257031732*^9}, {
   3.601752741521762*^9, 3.60175278027628*^9}, {3.6017528539062347`*^9, 
   3.6017528760288897`*^9}, {3.601752919973709*^9, 3.601752920071772*^9}, {
   3.6017530092084923`*^9, 3.6017530353146353`*^9}, {3.6017534746600924`*^9, 
   3.601753482951816*^9}, {3.601753653966588*^9, 3.601753657192586*^9}, {
   3.6017538679503736`*^9, 3.601753869045025*^9}, 3.6451930357748003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "flavorlist", ",", 
     RowBox[{"Round", "[", 
      RowBox[{"100", " ", "tab"}], "]"}]}], "}"}], " ", "//", "Transpose"}], 
  " ", "//", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], "&"}]}]], "Input",
 CellChangeTimes->{{3.594837426000315*^9, 3.594837512743508*^9}, {
   3.594837550221739*^9, 3.594837550940566*^9}, {3.59483763237888*^9, 
   3.594837708593923*^9}, {3.594837752075708*^9, 3.594837786565183*^9}, {
   3.601751798344823*^9, 3.601751811639182*^9}, {3.601753056194503*^9, 
   3.601753063082972*^9}, {3.6017531033184557`*^9, 3.601753103783552*^9}, 
   3.601753452524457*^9, {3.601753873217416*^9, 3.60175387477721*^9}, 
   3.645193035776854*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Check sum rule:", "Subsubsection",
 CellChangeTimes->{{3.55838969078966*^9, 3.558389705520049*^9}, {
   3.5599433920286007`*^9, 3.559943405337268*^9}, {3.578094482321333*^9, 
   3.5780944985775747`*^9}, 3.6017517105076313`*^9, 3.645193035769907*^9}],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"NIntegrate", "::", "izero"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Off", "[", 
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q0", "=", "2.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"iset0", "=", 
    RowBox[{
     RowBox[{"Length", "[", "pdfSetList", "]"}], "-", 
     RowBox[{"Length", "[", "CTEQ66", "]"}], "+", "1"}]}], ";"}], 
  RowBox[{"(*", "CTEQ66", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.558388176662824*^9, 3.558388237585742*^9}, {
   3.558388316374671*^9, 3.558388339130072*^9}, {3.558877222312537*^9, 
   3.558877222411696*^9}, 3.558914951117453*^9, 3.558916269097796*^9, {
   3.559663948356461*^9, 3.559664003410111*^9}, 3.559943258309353*^9, {
   3.593266820949542*^9, 3.5932668317122517`*^9}, 3.593904688611562*^9, {
   3.5948366962967*^9, 3.594836697605308*^9}, {3.594836836164318*^9, 
   3.594836854014057*^9}, 3.594836918672712*^9, 3.601752014609395*^9, {
   3.645188602471499*^9, 3.6451886025211983`*^9}, 3.6451930357701893`*^9, 
   3.645208836812763*^9, {3.645380317575205*^9, 3.645380337776173*^9}, {
   3.645380398025444*^9, 3.6453804047157097`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"tab", "=", " ", 
   RowBox[{"Table", "[", " ", 
    RowBox[{
     RowBox[{"NIntegrate", "[", " ", 
      RowBox[{
       RowBox[{"x", " ", 
        RowBox[{"pdf", "[", 
         RowBox[{"iset0", ",", "ipart", ",", "x", ",", "q0"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"ipart", ",", 
       RowBox[{"-", "5"}], ",", "5", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plus", " ", "@@", " ", "tab"}]}], "Input",
 CellChangeTimes->{{3.594837134140593*^9, 3.594837135493274*^9}, {
   3.601751751037738*^9, 3.601751752971987*^9}, 3.601752278398031*^9, {
   3.6326207495695143`*^9, 3.632620750524805*^9}, 3.635701610608427*^9, 
   3.637579731131372*^9, 3.645193035771167*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"flavorlist", "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.601752882211306*^9, 3.6017528887835417`*^9}, {
   3.6017534889266443`*^9, 3.601753489856092*^9}, 3.601753646443508*^9, {
   3.6017538512802343`*^9, 3.601753858127514*^9}, 3.645193035772922*^9}],

Cell[BoxData[
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", 
    RowBox[{"-", "5"}]}], ",", 
   RowBox[{"i", "\[LessEqual]", "5"}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{
    RowBox[{"AppendTo", "[", 
     RowBox[{"flavorlist", ",", 
      RowBox[{"pdfFlavor", "[", "i", "]"}]}], "]"}], ";"}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.601753610123262*^9, 3.601753643329199*^9}, {
   3.601753677793241*^9, 3.601753679638341*^9}, {3.601753747801209*^9, 
   3.601753756136877*^9}, {3.60175378894305*^9, 3.60175384772458*^9}, 
   3.620503230549233*^9, {3.632853466181031*^9, 3.632853470753668*^9}, 
   3.63757999765338*^9, 3.645193035773881*^9}],

Cell[BoxData["flavorlist"], "Input",
 CellChangeTimes->{{3.601752562361206*^9, 3.60175257031732*^9}, {
   3.601752741521762*^9, 3.60175278027628*^9}, {3.6017528539062347`*^9, 
   3.6017528760288897`*^9}, {3.601752919973709*^9, 3.601752920071772*^9}, {
   3.6017530092084923`*^9, 3.6017530353146353`*^9}, {3.6017534746600924`*^9, 
   3.601753482951816*^9}, {3.601753653966588*^9, 3.601753657192586*^9}, {
   3.6017538679503736`*^9, 3.601753869045025*^9}, 3.6451930357748003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "5"}], "]"}], ",", "flavorlist", ",", 
     RowBox[{"Round", "[", 
      RowBox[{"100", " ", "tab"}], "]"}]}], "}"}], " ", "//", "Transpose"}], 
  " ", "//", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], "&"}]}]], "Input",
 CellChangeTimes->{{3.594837426000315*^9, 3.594837512743508*^9}, {
   3.594837550221739*^9, 3.594837550940566*^9}, {3.59483763237888*^9, 
   3.594837708593923*^9}, {3.594837752075708*^9, 3.594837786565183*^9}, {
   3.601751798344823*^9, 3.601751811639182*^9}, {3.601753056194503*^9, 
   3.601753063082972*^9}, {3.6017531033184557`*^9, 3.601753103783552*^9}, 
   3.601753452524457*^9, {3.601753873217416*^9, 3.60175387477721*^9}, 
   3.645193035776854*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compare PDS and LHA files", "Subsection",
 CellChangeTimes->{{3.64538041911712*^9, 3.645380431727203*^9}}],

Cell[CellGroupData[{

Cell["\<\
Here we compare the CT10 PDF family in both the LHA and PDS formats. As \
expected, they yield the same results.\
\>", "Subsubsection",
 CellChangeTimes->{{3.578094880286613*^9, 3.578094920551873*^9}, {
  3.578094973528982*^9, 3.57809499395787*^9}, {3.578095545999968*^9, 
  3.578095582173026*^9}, {3.578095613781921*^9, 3.578095715100192*^9}, {
  3.578164147247816*^9, 3.578164151352611*^9}, {3.593905131761115*^9, 
  3.593905162063147*^9}, {3.6019178279276733`*^9, 3.6019178601873302`*^9}, {
  3.6452089567758427`*^9, 3.645208968240361*^9}, {3.645381308523485*^9, 
  3.6453813785561657`*^9}}],

Cell[BoxData[
 RowBox[{"ct10LHA", "=", 
  RowBox[{"pdfFamilyParseLHA", "[", "dirCT10", "]"}]}]], "Input",
 CellChangeTimes->{{3.645380507049222*^9, 3.645380524147771*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"q0", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"centralvaluePDS", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"centralvalueLHA", "=", 
   RowBox[{
    RowBox[{"Length", "[", "pdfSetList", "]"}], "-", 
    RowBox[{"Length", "[", "ct10LHA", "]"}], "+", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.558389298043715*^9, 3.558389383441816*^9}, {
   3.558389771118386*^9, 3.558389887362409*^9}, {3.5588770710473022`*^9, 
   3.558877079936973*^9}, {3.558877133107316*^9, 3.5588771570432997`*^9}, {
   3.558877187813177*^9, 3.558877188701536*^9}, {3.558915052449852*^9, 
   3.5589151055242443`*^9}, {3.559944477956419*^9, 3.559944479821953*^9}, {
   3.561902017541214*^9, 3.5619020184453697`*^9}, {3.561903548503592*^9, 
   3.56190354859699*^9}, {3.56199737366618*^9, 3.561997378465881*^9}, {
   3.561998044348396*^9, 3.561998044777002*^9}, {3.563555573300335*^9, 
   3.563555583719665*^9}, 3.563555657692699*^9, {3.563573340109346*^9, 
   3.563573343230054*^9}, {3.563574248658873*^9, 3.563574253801478*^9}, {
   3.578094828654139*^9, 3.578094872242288*^9}, {3.578095095624116*^9, 
   3.578095139310384*^9}, {3.5808405966204853`*^9, 3.58084060222915*^9}, {
   3.5884233722576313`*^9, 3.58842337244928*^9}, {3.593266905674479*^9, 
   3.593266925143467*^9}, {3.593905173199896*^9, 3.593905211033351*^9}, {
   3.593905248892988*^9, 3.593905274763945*^9}, {3.593905555693705*^9, 
   3.593905634637241*^9}, {3.5939058286962433`*^9, 3.5939058385207*^9}, {
   3.593905928455616*^9, 3.5939060757552958`*^9}, {3.593906140461885*^9, 
   3.5939061515200653`*^9}, {3.593906209324853*^9, 3.593906278379835*^9}, {
   3.593906344245811*^9, 3.5939064547517757`*^9}, {3.5939064958715563`*^9, 
   3.593906505812154*^9}, {3.5939066125030603`*^9, 3.593906667535852*^9}, {
   3.593906704457993*^9, 3.5939067116273317`*^9}, {3.5939088735479317`*^9, 
   3.593908887249167*^9}, {3.593911382007868*^9, 3.593911391696353*^9}, {
   3.594051854989216*^9, 3.5940518550640497`*^9}, {3.594051892673172*^9, 
   3.5940518927580967`*^9}, {3.5940520019712*^9, 3.5940520036123657`*^9}, 
   3.594826556092084*^9, {3.594826612147106*^9, 3.594826626231467*^9}, {
   3.594826735521295*^9, 3.594826771077426*^9}, {3.594826943777868*^9, 
   3.594826944896225*^9}, {3.594827051058401*^9, 3.594827141590041*^9}, {
   3.594827186402011*^9, 3.594827202637112*^9}, {3.594827249277203*^9, 
   3.594827249616434*^9}, {3.594833698062989*^9, 3.594833698359328*^9}, {
   3.601755056265823*^9, 3.6017551266888237`*^9}, {3.601755170403851*^9, 
   3.601755176145411*^9}, 3.601755859698276*^9, {3.601756008485155*^9, 
   3.601756014374342*^9}, {3.601869381317051*^9, 3.6018693817210197`*^9}, 
   3.632621077883027*^9, 3.6327686889286413`*^9, {3.645380549781686*^9, 
   3.6453805696963463`*^9}, {3.64538068982652*^9, 3.645380692361497*^9}}],

Cell[BoxData[
 RowBox[{"pdf", "[", 
  RowBox[{"centralvalueLHA", ",", "1", ",", ".1", ",", "1.5"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6453814044792967`*^9, 3.645381497880175*^9}}],

Cell[BoxData[
 RowBox[{"pdf", "[", 
  RowBox[{"centralvaluePDS", ",", "1", ",", ".1", ",", "1.5"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6453814566692657`*^9, 3.645381495739587*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"xMin", "=", 
   RowBox[{"Max", "[", 
    RowBox[{
     RowBox[{"pdfXmin", "[", "centralvaluePDS", "]"}], ",", 
     RowBox[{"pdfXmin", "[", "centralvalueLHA", "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.645380630195157*^9, 3.645380700124346*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", 
     RowBox[{"-", "5"}]}], ",", 
    RowBox[{"i", "\[LessEqual]", "5"}], ",", 
    RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"LogLinearPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"pdf", "[", 
            RowBox[{"centralvaluePDS", ",", "i", ",", "x", ",", "q0"}], "]"}],
            ",", 
           RowBox[{"pdf", "[", 
            RowBox[{"centralvalueLHA", ",", "i", ",", "x", ",", "q0"}], 
            "]"}]}], "}"}]}], "//", "Evaluate"}], " ", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"xMin", "*", "100"}], ",", "1"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Directive", "[", 
           RowBox[{"Magenta", ",", 
            RowBox[{"Thickness", "[", "0.016", "]"}]}], "]"}], ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Green", ",", 
            RowBox[{"Thickness", "[", "0.008", "]"}], ",", 
            RowBox[{"Dashing", "[", ".0", "]"}]}], "]"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotLabel", "\[Rule]", 
        RowBox[{"pdfFlavor", "[", "i", "]"}]}], " ", ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", "\"\<x*pdf[x]\>\""}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ImageSize", "\[Rule]", "Large"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"PlotLegends", "\[Rule]", 
        RowBox[{"Placed", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<LHA\>\"", ",", "\"\<PDS\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.1", ",", "0.18"}], "}"}]}], "]"}]}]}], "]"}], " ", "//",
      "Print"}]}], "\[IndentingNewLine]", "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.558389298043715*^9, 3.558389383441816*^9}, {
   3.558389771118386*^9, 3.558389887362409*^9}, {3.5588770710473022`*^9, 
   3.558877079936973*^9}, {3.558877133107316*^9, 3.5588771570432997`*^9}, {
   3.558877187813177*^9, 3.558877188701536*^9}, {3.558915052449852*^9, 
   3.5589151055242443`*^9}, {3.559944477956419*^9, 3.559944479821953*^9}, {
   3.561902017541214*^9, 3.5619020184453697`*^9}, {3.561903548503592*^9, 
   3.56190354859699*^9}, {3.56199737366618*^9, 3.561997378465881*^9}, {
   3.561998044348396*^9, 3.561998044777002*^9}, {3.563555573300335*^9, 
   3.563555583719665*^9}, 3.563555657692699*^9, {3.563573340109346*^9, 
   3.563573343230054*^9}, {3.563574248658873*^9, 3.563574253801478*^9}, {
   3.578094828654139*^9, 3.578094872242288*^9}, {3.578095095624116*^9, 
   3.578095139310384*^9}, {3.5808405966204853`*^9, 3.58084060222915*^9}, {
   3.5884233722576313`*^9, 3.58842337244928*^9}, {3.593266905674479*^9, 
   3.593266925143467*^9}, {3.593905173199896*^9, 3.593905211033351*^9}, {
   3.593905248892988*^9, 3.593905274763945*^9}, {3.593905555693705*^9, 
   3.593905634637241*^9}, {3.5939058286962433`*^9, 3.5939058385207*^9}, {
   3.593905928455616*^9, 3.5939060757552958`*^9}, {3.593906140461885*^9, 
   3.5939061515200653`*^9}, {3.593906209324853*^9, 3.593906278379835*^9}, {
   3.593906344245811*^9, 3.5939064547517757`*^9}, {3.5939064958715563`*^9, 
   3.593906505812154*^9}, {3.5939066125030603`*^9, 3.593906667535852*^9}, {
   3.593906704457993*^9, 3.5939067116273317`*^9}, {3.5939088735479317`*^9, 
   3.593908887249167*^9}, {3.593911382007868*^9, 3.593911391696353*^9}, {
   3.594051854989216*^9, 3.5940518550640497`*^9}, {3.594051892673172*^9, 
   3.5940518927580967`*^9}, {3.5940520019712*^9, 3.5940520036123657`*^9}, 
   3.594826556092084*^9, {3.594826612147106*^9, 3.594826626231467*^9}, {
   3.594826735521295*^9, 3.594826771077426*^9}, {3.594826943777868*^9, 
   3.594826944896225*^9}, {3.594827051058401*^9, 3.594827141590041*^9}, {
   3.594827186402011*^9, 3.594827202637112*^9}, {3.594827249277203*^9, 
   3.594827249616434*^9}, {3.594833698062989*^9, 3.594833698359328*^9}, {
   3.601755056265823*^9, 3.6017551266888237`*^9}, {3.601755170403851*^9, 
   3.601755176145411*^9}, 3.601755859698276*^9, {3.601756533485606*^9, 
   3.601756536109228*^9}, {3.601868771085828*^9, 3.601868777043646*^9}, {
   3.6018689973249693`*^9, 3.601869035318097*^9}, {3.601869135075268*^9, 
   3.601869192741187*^9}, 3.620503273121613*^9, 3.632853360308758*^9, 
   3.633281585592968*^9, {3.6453805863524237`*^9, 3.645380592507811*^9}, {
   3.645380761357559*^9, 3.645380768486534*^9}, {3.6453809229752903`*^9, 
   3.645380931724309*^9}, {3.6453809993238287`*^9, 3.645381003224774*^9}, {
   3.6453810749111757`*^9, 3.6453810766944323`*^9}, {3.645381175565795*^9, 
   3.6453811810518827`*^9}, {3.645381228847212*^9, 3.645381265942354*^9}, {
   3.647098855967753*^9, 3.647098922257918*^9}}]
}, Open  ]]
}, Open  ]]
}, Closed]]
},
CellGrouping->Manual,
WindowSize->{2560, 1337},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
FrontEndVersion->"10.3 for Linux x86 (64-bit) (December 10, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 408, 7, 63, "Input"],
Cell[968, 29, 1206, 16, 188, "Title"],
Cell[2177, 47, 1198, 18, 454, "Subsection"],
Cell[CellGroupData[{
Cell[3400, 69, 346, 5, 100, "Section"],
Cell[CellGroupData[{
Cell[3771, 78, 393, 6, 122, "Subsubsection"],
Cell[4167, 86, 174, 3, 63, "Input"],
Cell[4344, 91, 221, 4, 63, "Input"],
Cell[4568, 97, 1495, 33, 316, "Input"],
Cell[6066, 132, 499, 10, 106, "Input"],
Cell[6568, 144, 103, 1, 63, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[6720, 151, 249, 3, 100, "Section"],
Cell[CellGroupData[{
Cell[6994, 158, 200, 3, 72, "Subsubsection"],
Cell[7197, 163, 177, 5, 63, "Input"],
Cell[7377, 170, 245, 6, 63, "Input"],
Cell[7625, 178, 290, 7, 63, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7952, 190, 251, 5, 72, "Subsubsection"],
Cell[8206, 197, 164, 3, 63, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8419, 206, 237, 3, 100, "Section"],
Cell[CellGroupData[{
Cell[8681, 213, 303, 6, 122, "Subsubsection"],
Cell[8987, 221, 173, 3, 63, "Input"],
Cell[9163, 226, 849, 21, 148, "Input"],
Cell[10015, 249, 779, 15, 63, "Input"],
Cell[10797, 266, 552, 12, 63, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11386, 283, 548, 9, 122, "Subsubsection"],
Cell[11937, 294, 353, 5, 63, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12327, 304, 436, 8, 72, "Subsubsection"],
Cell[12766, 314, 715, 13, 63, "Input"],
Cell[13484, 329, 384, 6, 63, "Input"]
}, Open  ]],
Cell[13883, 338, 472, 8, 72, "Subsubsection"]
}, Closed]],
Cell[CellGroupData[{
Cell[14392, 351, 307, 4, 100, "Section"],
Cell[CellGroupData[{
Cell[14724, 359, 260, 5, 72, "Subsubsection"],
Cell[14987, 366, 342, 5, 63, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15366, 376, 171, 2, 72, "Subsubsection"],
Cell[15540, 380, 212, 3, 63, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15789, 388, 517, 9, 122, "Subsubsection"],
Cell[16309, 399, 176, 3, 63, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16522, 407, 583, 9, 122, "Subsubsection"],
Cell[17108, 418, 692, 11, 63, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17849, 435, 166, 2, 100, "Section"],
Cell[CellGroupData[{
Cell[18040, 441, 996, 21, 122, "Subsubsection"],
Cell[19039, 464, 339, 5, 63, "Input"],
Cell[19381, 471, 861, 13, 63, "Input"],
Cell[20245, 486, 1045, 19, 106, "Input"],
Cell[21293, 507, 790, 18, 274, "Input"]
}, Open  ]],
Cell[22098, 528, 102, 1, 90, "Subsection"],
Cell[22203, 531, 484, 12, 47, "Input"],
Cell[22690, 545, 526, 13, 63, "Input"],
Cell[CellGroupData[{
Cell[23241, 562, 255, 3, 72, "Subsubsection"],
Cell[23499, 567, 1024, 21, 190, "Input"],
Cell[24526, 590, 1317, 30, 190, "Input"],
Cell[25846, 622, 311, 6, 63, "Input"],
Cell[26160, 630, 660, 16, 63, "Input"],
Cell[26823, 648, 478, 6, 63, "Input"],
Cell[27304, 656, 883, 21, 63, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28236, 683, 338, 4, 100, "Section"],
Cell[CellGroupData[{
Cell[28599, 691, 273, 4, 72, "Subsubsection"],
Cell[28875, 697, 215, 4, 63, "Input"],
Cell[29093, 703, 345, 6, 63, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29475, 714, 623, 10, 122, "Subsubsection"],
Cell[30101, 726, 2633, 39, 148, "Input"],
Cell[32737, 767, 4863, 94, 568, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37649, 867, 355, 5, 100, "Section"],
Cell[CellGroupData[{
Cell[38029, 876, 332, 5, 72, "Subsubsection"],
Cell[38364, 883, 96, 1, 63, "Input"],
Cell[38463, 886, 353, 6, 63, "Input"],
Cell[38819, 894, 1962, 50, 484, "Input"],
Cell[40784, 946, 265, 5, 63, "Input"],
Cell[41052, 953, 1496, 32, 190, "Input"],
Cell[42551, 987, 1156, 27, 232, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43756, 1020, 104, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[43885, 1025, 185, 4, 72, "Subsubsection"],
Cell[44073, 1031, 187, 4, 63, "Input"],
Cell[44263, 1037, 405, 8, 63, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44705, 1050, 168, 3, 72, "Subsubsection"],
Cell[44876, 1055, 1011, 24, 148, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45936, 1085, 315, 4, 100, "Section"],
Cell[CellGroupData[{
Cell[46276, 1093, 152, 2, 72, "Subsubsection"],
Cell[46431, 1097, 184, 4, 63, "Input"],
Cell[46618, 1103, 350, 5, 63, "Input"],
Cell[46971, 1110, 401, 6, 63, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47409, 1121, 469, 8, 72, "Subsubsection"],
Cell[47881, 1131, 230, 4, 63, "Input"],
Cell[48114, 1137, 310, 5, 63, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48473, 1148, 210, 3, 100, "Section"],
Cell[CellGroupData[{
Cell[48708, 1155, 229, 3, 90, "Subsection"],
Cell[CellGroupData[{
Cell[48962, 1162, 177, 3, 72, "Subsubsection"],
Cell[49142, 1167, 144, 3, 63, "Input"],
Cell[49289, 1172, 457, 9, 106, "Input"],
Cell[49749, 1183, 217, 4, 63, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50015, 1193, 178, 2, 90, "Subsection"],
Cell[50196, 1197, 395, 7, 63, "Input"],
Cell[50594, 1206, 666, 10, 63, "Input"],
Cell[51263, 1218, 568, 10, 63, "Input"],
Cell[51834, 1230, 374, 9, 63, "Input"],
Cell[52211, 1241, 2326, 53, 316, "Input"],
Cell[54540, 1296, 348, 9, 63, "Input"],
Cell[54891, 1307, 1082, 21, 63, "Input"],
Cell[CellGroupData[{
Cell[55998, 1332, 216, 3, 72, "Subsubsection"],
Cell[56217, 1337, 1790, 42, 316, "Input"],
Cell[58010, 1381, 1384, 25, 63, "Input"],
Cell[59397, 1408, 1405, 30, 106, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60839, 1443, 197, 4, 72, "Subsubsection"],
Cell[61039, 1449, 1156, 26, 190, "Input"],
Cell[62198, 1477, 402, 7, 63, "Input"],
Cell[62603, 1486, 982, 27, 106, "Input"],
Cell[63588, 1515, 847, 19, 63, "Input"],
Cell[64438, 1536, 251, 5, 63, "Input"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[64750, 1548, 216, 3, 100, "Section"],
Cell[CellGroupData[{
Cell[64991, 1555, 262, 5, 90, "Subsection"],
Cell[65256, 1562, 220, 4, 63, "Input"],
Cell[65479, 1568, 314, 5, 63, "Input"],
Cell[65796, 1575, 457, 9, 63, "Input"],
Cell[66256, 1586, 400, 8, 106, "Input"],
Cell[66659, 1596, 1178, 26, 148, "Input"],
Cell[67840, 1624, 212, 4, 63, "Input"],
Cell[68055, 1630, 207, 4, 63, "Input"],
Cell[CellGroupData[{
Cell[68287, 1638, 325, 6, 72, "Subsubsection"],
Cell[68615, 1646, 127, 2, 63, "Input"],
Cell[68745, 1650, 135, 2, 63, "Input"]
}, Open  ]],
Cell[68895, 1655, 283, 6, 63, "Input"],
Cell[69181, 1663, 307, 5, 63, "Input"],
Cell[69491, 1670, 2019, 39, 190, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71547, 1714, 180, 2, 90, "Subsection"],
Cell[71730, 1718, 220, 4, 63, "Input"],
Cell[71953, 1724, 579, 10, 148, "Input"],
Cell[72535, 1736, 157, 3, 63, "Input"],
Cell[72695, 1741, 201, 5, 63, "Input"],
Cell[CellGroupData[{
Cell[72921, 1750, 233, 3, 72, "Subsubsection"],
Cell[73157, 1755, 973, 22, 190, "Input"],
Cell[74133, 1779, 761, 19, 106, "Input"],
Cell[74897, 1800, 289, 6, 63, "Input"],
Cell[75189, 1808, 567, 15, 63, "Input"],
Cell[75759, 1825, 449, 6, 63, "Input"],
Cell[76211, 1833, 857, 20, 63, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[77105, 1858, 233, 3, 72, "Subsubsection"],
Cell[77341, 1863, 1180, 26, 190, "Input"],
Cell[78524, 1891, 761, 19, 106, "Input"],
Cell[79288, 1912, 289, 6, 63, "Input"],
Cell[79580, 1920, 567, 15, 63, "Input"],
Cell[80150, 1937, 449, 6, 63, "Input"],
Cell[80602, 1945, 958, 22, 63, "Input"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[81621, 1974, 93, 1, 100, "Section"],
Cell[CellGroupData[{
Cell[81739, 1979, 171, 3, 90, "Subsection"],
Cell[81913, 1984, 122, 2, 63, "Input"],
Cell[82038, 1988, 249, 4, 63, "Input"],
Cell[82290, 1994, 249, 4, 63, "Input"],
Cell[82542, 2000, 762, 11, 63, "Input"],
Cell[83307, 2013, 1045, 19, 106, "Input"],
Cell[84355, 2034, 790, 18, 274, "Input"],
Cell[CellGroupData[{
Cell[85170, 2056, 255, 3, 72, "Subsubsection"],
Cell[85428, 2061, 978, 21, 190, "Input"],
Cell[86409, 2084, 830, 20, 106, "Input"],
Cell[87242, 2106, 311, 6, 63, "Input"],
Cell[87556, 2114, 660, 16, 63, "Input"],
Cell[88219, 2132, 478, 6, 63, "Input"],
Cell[88700, 2140, 883, 21, 63, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89620, 2166, 255, 3, 72, "Subsubsection"],
Cell[89878, 2171, 1246, 27, 190, "Input"],
Cell[91127, 2200, 830, 20, 106, "Input"],
Cell[91960, 2222, 311, 6, 63, "Input"],
Cell[92274, 2230, 660, 16, 63, "Input"],
Cell[92937, 2248, 478, 6, 63, "Input"],
Cell[93418, 2256, 883, 21, 63, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[94350, 2283, 112, 1, 90, "Subsection"],
Cell[CellGroupData[{
Cell[94487, 2288, 604, 10, 72, "Subsubsection"],
Cell[95094, 2300, 171, 3, 63, "Input"],
Cell[95268, 2305, 2857, 43, 148, "Input"],
Cell[98128, 2350, 187, 4, 63, "Input"],
Cell[98318, 2356, 187, 4, 63, "Input"],
Cell[98508, 2362, 297, 8, 63, "Input"],
Cell[98808, 2372, 5430, 103, 568, "Input"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}
]
*)

(* End of internal cache information *)
